<?php
// Set consistent session configuration
session_name('ADINOHEIGHT_SESSION');
ini_set('session.cookie_lifetime', 0);
ini_set('session.cookie_secure', isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on');
ini_set('session.cookie_httponly', true);
ini_set('session.cookie_samesite', 'Lax');

ob_start();
session_start();
include '../config/conn.php';

// Enhanced check if user is logged in
if (!isset($_SESSION['user_id']) || !isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    // Use absolute path for redirection
    header('Location: /portal/login.php'); // Adjust this path as needed
    exit();
}


$student_id = $_SESSION['user_id'];
$error = '';

// Fetch student details
$student_query = "SELECT s.*, c.class_name, sec.section_name 
                  FROM students s 
                  LEFT JOIN classes c ON s.class = c.id 
                  LEFT JOIN sections sec ON s.section = sec.id 
                  WHERE s.id = $student_id";
$student_result = mysqli_query($conn, $student_query);
$student = mysqli_fetch_assoc($student_result);

// Get test results if requested
$test_result = null;
$test_details = null;
$test_answers = [];

if (isset($_GET['view_result']) && is_numeric($_GET['view_result'])) {
    $test_id = intval($_GET['view_result']);
    
    // Check if student can view this result
    $result_query = "SELECT qr.*, q.quiz_title, s.subject_name 
                    FROM quiz_results qr 
                    JOIN quizzes q ON qr.quiz_id = q.id 
                    JOIN subjects s ON q.subject_id = s.id 
                    WHERE qr.quiz_id = $test_id AND qr.student_id = $student_id AND qr.result_released = 1";
    $result_result = mysqli_query($conn, $result_query);
    
    if ($result_result && mysqli_num_rows($result_result) > 0) {
        $test_result = mysqli_fetch_assoc($result_result);
        
        // Get test details
        $test_details_query = "SELECT * FROM quizzes WHERE id = $test_id";
        $test_details_result = mysqli_query($conn, $test_details_query);
        if ($test_details_result) {
            $test_details = mysqli_fetch_assoc($test_details_result);
        }
        
        // Get student's answers
        $answers_query = "SELECT qa.*, qq.question_text, qq.question_type, qq.marks, 
                         qo.option_text as selected_option, qo.is_correct as option_correct
                         FROM quiz_answers qa 
                         JOIN quiz_questions qq ON qa.question_id = qq.id 
                         LEFT JOIN quiz_question_options qo ON qa.option_id = qo.id 
                         WHERE qa.result_id = {$test_result['id']} 
                         ORDER BY qq.id";
        $answers_result = mysqli_query($conn, $answers_query);
        
        if ($answers_result) {
            while ($answer = mysqli_fetch_assoc($answers_result)) {
                $test_answers[] = $answer;
            }
        }
    } else {
        $error = "Results for this test are not available yet or you don't have permission to view them.";
    }
}

// Fetch all released results for this student
$results_query = "SELECT qr.*, q.quiz_title, s.subject_name 
                 FROM quiz_results qr 
                 JOIN quizzes q ON qr.quiz_id = q.id 
                 JOIN subjects s ON q.subject_id = s.id 
                 WHERE qr.student_id = $student_id AND qr.result_released = 1 
                 ORDER BY qr.submitted_at DESC";
$results_result = mysqli_query($conn, $results_query);
$released_results = [];

if ($results_result) {
    while ($result = mysqli_fetch_assoc($results_result)) {
        $released_results[] = $result;
    }
} else {
    $error = "Error fetching results: " . mysqli_error($conn);
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>View Test Results - Student</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="bg-gray-50">
    <div class="container mx-auto px-0 py-0">
        <!-- Header -->
        

        <?php if (!empty($error)): ?>
            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-6">
                <i class="fas fa-exclamation-circle mr-2"></i> <?php echo htmlspecialchars($error); ?>
            </div>
        <?php endif; ?>

        <!-- Test Results View -->
        <?php if ($test_result && $test_details): ?>
            <div class="bg-white  p-6 mb-6">
                <h2 class="text-xl font-bold text-gray-800 mb-4">Test Results: <?php echo htmlspecialchars($test_result['quiz_title']); ?></h2>
                
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-6">
                    <div class="bg-blue-50 p-4  text-center">
                        <p class="text-2xl font-bold"><?php echo $test_result['score'] . '/' . $test_result['total_marks']; ?></p>
                        <p class="text-gray-600">Score</p>
                    </div>
                    
                    <div class="bg-green-50 p-4  text-center">
                        <p class="text-2xl font-bold"><?php echo $test_result['percentage']; ?>%</p>
                        <p class="text-gray-600">Percentage</p>
                    </div>
                    
                    <div class="bg-purple-50 p-4  text-center">
                        <p class="text-2xl font-bold"><?php echo gmdate("i:s", $test_result['time_taken']); ?></p>
                        <p class="text-gray-600">Time Taken</p>
                    </div>
                </div>
                
                <div class="mt-6 bg-gray-50 p-4  mb-6">
                    <h3 class="font-semibold mb-2">Test Details:</h3>
                    <p><span class="font-medium">Subject:</span> <?php echo htmlspecialchars($test_result['subject_name']); ?></p>
                    <p><span class="font-medium">Submitted on:</span> <?php echo date('M j, Y g:i A', strtotime($test_result['submitted_at'])); ?></p>
                </div>
                
                <!-- Answer Review -->
                <?php if (!empty($test_answers)): ?>
                    <h3 class="text-lg font-semibold text-gray-800 mb-4">Question Review</h3>
                    
                    <div class="space-y-6">
                        <?php foreach ($test_answers as $index => $answer): ?>
                            <div class="border  p-4 <?php echo ($answer['question_type'] == 'multiple_choice' && $answer['option_correct']) ? 'bg-green-50 border-green-200' : 'bg-red-50 border-red-200'; ?>">
                                <p class="font-semibold mb-2">Question <?php echo $index + 1; ?>: 
                                    <span class="text-sm font-normal text-gray-600">(<?php echo $answer['marks']; ?> marks)</span>
                                </p>
                                <p class="mb-3"><?php echo htmlspecialchars($answer['question_text']); ?></p>
                                
                                <?php if ($answer['question_type'] == 'multiple_choice'): ?>
                                    <p class="mb-2 font-medium">Your answer:</p>
                                    <p class="ml-4 p-2 <?php echo $answer['option_correct'] ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800'; ?> rounded">
                                        <?php echo htmlspecialchars($answer['selected_option']); ?>
                                        <?php if ($answer['option_correct']): ?>
                                            <i class="fas fa-check ml-2"></i>
                                        <?php else: ?>
                                            <i class="fas fa-times ml-2"></i>
                                        <?php endif; ?>
                                    </p>
                                    
                                    <?php if (!$answer['option_correct']): ?>
                                        <?php 
                                        // Get correct answer
                                        $correct_option_query = "SELECT option_text FROM quiz_question_options 
                                                               WHERE question_id = {$answer['question_id']} AND is_correct = 1";
                                        $correct_option_result = mysqli_query($conn, $correct_option_query);
                                        $correct_option = mysqli_fetch_assoc($correct_option_result);
                                        ?>
                                        <p class="mt-2 font-medium">Correct answer:</p>
                                        <p class="ml-4 p-2 bg-green-100 text-green-800 rounded"><?php echo htmlspecialchars($correct_option['option_text']); ?></p>
                                    <?php endif; ?>
                                    
                                <?php else: ?>
                                    <p class="mb-2 font-medium">Your answer:</p>
                                    <div class="ml-4 p-3 bg-gray-100 rounded">
                                        <?php echo nl2br(htmlspecialchars($answer['answer_text'])); ?>
                                    </div>
                                    <p class="mt-3 text-sm text-gray-600"><i class="fas fa-info-circle mr-1"></i> This question requires manual grading by your instructor.</p>
                                <?php endif; ?>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
                
                <div class="mt-8 flex justify-center space-x-4">
                    <a href="view_result.php" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 ">
                        <i class="fas fa-arrow-left mr-2"></i> Back to Results
                    </a>
                    
                    <button onclick="window.print()" class="bg-green-600 hover:bg-green-700 text-white px-4 py-2 ">
                        <i class="fas fa-download mr-2"></i> Download Results
                    </button>
                </div>
            </div>

        <!-- Results Listing -->
        <?php else: ?>
            <div class="bg-white  p-6">
                <h2 class="text-xl font-bold text-gray-800 mb-4">Your Test Results</h2>
                
                <?php if (!empty($released_results)): ?>
                    <div class="overflow-x-auto">
                        <table class="min-w-full bg-white">
                            <thead class="bg-gray-200 text-gray-700">
                                <tr>
                                    <th class="py-3 px-4 text-left">Test Name</th>
                                    <th class="py-3 px-4 text-left">Subject</th>
                                    <th class="py-3 px-4 text-left">Date Taken</th>
                                    <th class="py-3 px-4 text-left">Score</th>
                                    <th class="py-3 px-4 text-left">Percentage</th>
                                    <th class="py-3 px-4 text-left">Actions</th>
                                </tr>
                            </thead>
                            <tbody class="text-gray-600">
                                <?php foreach ($released_results as $result): ?>
                                    <tr class="border-b border-gray-200 hover:bg-gray-50">
                                        <td class="py-3 px-4"><?php echo htmlspecialchars($result['quiz_title']); ?></td>
                                        <td class="py-3 px-4"><?php echo htmlspecialchars($result['subject_name']); ?></td>
                                        <td class="py-3 px-4"><?php echo date('M j, Y', strtotime($result['submitted_at'])); ?></td>
                                        <td class="py-3 px-4"><?php echo $result['score'] . '/' . $result['total_marks']; ?></td>
                                        <td class="py-3 px-4"><?php echo $result['percentage']; ?>%</td>
                                        <td class="py-3 px-4">
                                            <a href="view_result.php?view_result=<?php echo $result['quiz_id']; ?>" class="text-blue-600 hover:text-blue-800">
                                                <i class="fas fa-eye mr-1"></i> View Details
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <div class="text-center py-8">
                        <i class="fas fa-clipboard-list text-4xl text-gray-400 mb-4"></i>
                        <h3 class="text-xl font-semibold text-gray-700 mb-2">No Results Available</h3>
                        <p class="text-gray-500">Your test results will appear here once they are released by your instructor.</p>
                    </div>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>
</body>
</html>