<?php
ob_start();
include 'include/header.php';
include '../config/conn.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

// Get student information
$student_id = $_SESSION['user_id'];
$student_class = '';
$student_section = '';

// Fetch student details
$student_query = "SELECT s.*, c.class_name, sec.section_name 
                  FROM students s 
                  LEFT JOIN classes c ON s.class = c.id 
                  LEFT JOIN sections sec ON s.section = sec.id 
                  WHERE s.id = $student_id";
$student_result = mysqli_query($conn, $student_query);

if ($student_result && mysqli_num_rows($student_result) > 0) {
    $student_data = mysqli_fetch_assoc($student_result);
    $student_class = $student_data['class'];
    $student_section = $student_data['section'];
    $student_name = $student_data['full_name'];
} else {
    // If not a student, redirect
    header('Location: ../portal_logins.php');
    exit();
}

// Check if notice_views table exists, if not create it
$table_check = mysqli_query($conn, "SHOW TABLES LIKE 'notice_views'");
if (mysqli_num_rows($table_check) == 0) {
    // Create the notice_views table
    $create_table = "CREATE TABLE notice_views (
        id INT(11) PRIMARY KEY AUTO_INCREMENT,
        notice_id INT(11) NOT NULL,
        student_id INT(11) NOT NULL,
        viewed_at DATETIME NOT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (notice_id) REFERENCES notices(id) ON DELETE CASCADE,
        FOREIGN KEY (student_id) REFERENCES students(id) ON DELETE CASCADE,
        UNIQUE KEY unique_notice_view (notice_id, student_id)
    )";
    
    if (!mysqli_query($conn, $create_table)) {
        // If table creation fails, disable view tracking
        $view_tracking_enabled = false;
    } else {
        $view_tracking_enabled = true;
    }
} else {
    $view_tracking_enabled = true;
}

// Fetch notices relevant to this student
$current_date = date('Y-m-d');
$notices_query = "SELECT n.*, u.full_name as created_by_name 
                  FROM notices n 
                  LEFT JOIN users u ON n.created_by = u.id 
                  WHERE (n.audience_type = 'all' 
                         OR (n.audience_type = 'class' AND n.target_id = $student_class) 
                         OR (n.audience_type = 'section' AND n.target_id = $student_section) 
                         OR (n.audience_type = 'student' AND n.target_id = $student_id))
                  AND (n.expiry_date IS NULL OR n.expiry_date >= '$current_date')
                  ORDER BY 
                    CASE n.priority 
                        WHEN 'urgent' THEN 1 
                        WHEN 'high' THEN 2 
                        ELSE 3 
                    END, 
                    n.created_at DESC";
$notices_result = mysqli_query($conn, $notices_query);

// Handle notice view tracking if enabled
if ($view_tracking_enabled && isset($_GET['view_notice'])) {
    $notice_id = intval($_GET['view_notice']);
    
    // Check if already viewed
    $view_check_query = "SELECT id FROM notice_views WHERE notice_id = $notice_id AND student_id = $student_id";
    $view_check_result = mysqli_query($conn, $view_check_query);
    
    if (mysqli_num_rows($view_check_result) === 0) {
        // Mark as viewed
        $view_query = "INSERT INTO notice_views (notice_id, student_id, viewed_at) 
                       VALUES ($notice_id, $student_id, NOW())";
        mysqli_query($conn, $view_query);
    }
}
?>

<div class="bg-white p-6 rounded-lg">
    <div class="flex justify-between items-center mb-6">
        <div>
            <h2 class="text-2xl font-bold text-gray-800">Notice Board</h2>
            <p class="text-gray-600">Welcome, <?php echo $student_name; ?></p>
        </div>
        <div class="flex items-center space-x-2">
            <span class="bg-blue-100 text-blue-800 text-xs font-medium px-2.5 py-0.5 rounded-full">
                <?php echo $student_data['class_name'] . ' - ' . $student_data['section_name']; ?>
            </span>
        </div>
    </div>

    <!-- Filter Options -->
    <div class="mb-6 bg-gray-50 p-4 rounded-lg">
        <h3 class="text-lg font-semibold text-gray-800 mb-3">Filter Notices</h3>
        <div class="flex flex-wrap gap-2">
            <button onclick="filterNotices('all')" class="bg-blue-600 text-white px-3 py-1 rounded-lg text-sm filter-btn active">
                All Notices
            </button>
            <button onclick="filterNotices('unread')" class="bg-gray-600 text-white px-3 py-1 rounded-lg text-sm filter-btn">
                Unread Only
            </button>
            <button onclick="filterNotices('urgent')" class="bg-red-600 text-white px-3 py-1 rounded-lg text-sm filter-btn">
                Urgent
            </button>
            <button onclick="filterNotices('high')" class="bg-yellow-600 text-white px-3 py-1 rounded-lg text-sm filter-btn">
                High Priority
            </button>
        </div>
    </div>

    <!-- Notices List -->
    <div class="bg-white p-4 rounded-lg shadow">
        <h3 class="text-lg font-semibold text-gray-800 mb-4">Your Notices</h3>
        
        <?php if (mysqli_num_rows($notices_result) > 0): ?>
            <div class="space-y-4">
                <?php while ($notice = mysqli_fetch_assoc($notices_result)): 
                    // Check if notice has been viewed if tracking is enabled
                    $is_viewed = false;
                    if ($view_tracking_enabled) {
                        $view_query = "SELECT viewed_at FROM notice_views WHERE notice_id = {$notice['id']} AND student_id = $student_id";
                        $view_result = mysqli_query($conn, $view_query);
                        $is_viewed = mysqli_num_rows($view_result) > 0;
                    }
                    
                    // Determine audience text
                    $audience_text = '';
                    if ($notice['audience_type'] === 'all') {
                        $audience_text = 'All Students';
                    } elseif ($notice['audience_type'] === 'class') {
                        $class_query = "SELECT class_name FROM classes WHERE id = " . $notice['target_id'];
                        $class_result = mysqli_query($conn, $class_query);
                        if ($class_result && mysqli_num_rows($class_result) > 0) {
                            $class_name = mysqli_fetch_assoc($class_result)['class_name'];
                            $audience_text = 'Class: ' . $class_name;
                        }
                    } elseif ($notice['audience_type'] === 'section') {
                        $section_query = "SELECT s.section_name, c.class_name 
                                          FROM sections s 
                                          LEFT JOIN classes c ON s.class_id = c.id 
                                          WHERE s.id = " . $notice['target_id'];
                        $section_result = mysqli_query($conn, $section_query);
                        if ($section_result && mysqli_num_rows($section_result) > 0) {
                            $section = mysqli_fetch_assoc($section_result);
                            $audience_text = 'Section: ' . $section['class_name'] . ' - ' . $section['section_name'];
                        }
                    } elseif ($notice['audience_type'] === 'student') {
                        $student_query = "SELECT full_name FROM students WHERE id = " . $notice['target_id'];
                        $student_result = mysqli_query($conn, $student_query);
                        if ($student_result && mysqli_num_rows($student_result) > 0) {
                            $target_student = mysqli_fetch_assoc($student_result);
                            $audience_text = 'Student: ' . $target_student['full_name'];
                        }
                    }
                    
                    // Priority badge color
                    $priority_class = '';
                    switch ($notice['priority']) {
                        case 'high':
                            $priority_class = 'bg-yellow-100 text-yellow-800';
                            break;
                        case 'urgent':
                            $priority_class = 'bg-red-100 text-red-800';
                            break;
                        default:
                            $priority_class = 'bg-blue-100 text-blue-800';
                    }
                ?>
                    <div class="border border-gray-200 rounded-lg p-4 notice-item <?php echo $is_viewed ? 'bg-gray-50' : 'bg-white border-l-4 border-l-blue-500'; ?>" 
                         data-priority="<?php echo $notice['priority']; ?>" 
                         data-viewed="<?php echo $is_viewed ? 'true' : 'false'; ?>">
                        <div class="flex justify-between items-start mb-2">
                            <div>
                                <h4 class="font-semibold text-gray-800 text-lg"><?php echo $notice['title']; ?></h4>
                                <p class="text-sm text-gray-600"><?php echo $audience_text; ?></p>
                            </div>
                            <div class="flex items-center space-x-2">
                                <span class="text-xs font-medium px-2.5 py-0.5 rounded-full <?php echo $priority_class; ?>">
                                    <?php echo ucfirst($notice['priority']); ?>
                                </span>
                                <?php if (!$is_viewed && $view_tracking_enabled): ?>
                                    <span class="bg-red-500 text-white text-xs px-2 py-0.5 rounded-full">New</span>
                                <?php endif; ?>
                            </div>
                        </div>
                        
                        <div class="text-gray-700 mb-3">
                            <?php 
                            $content = $notice['content'];
                            if (strlen($content) > 150) {
                                echo nl2br(substr($content, 0, 150) . '...');
                            } else {
                                echo nl2br($content);
                            }
                            ?>
                        </div>
                        
                        <div class="flex justify-between items-center text-sm text-gray-500">
                            <div>
                                <span>Posted by: <?php echo $notice['created_by_name']; ?></span>
                                <span class="mx-2">•</span>
                                <span><?php echo date('M j, Y', strtotime($notice['created_at'])); ?></span>
                                <?php if ($notice['expiry_date']): ?>
                                    <span class="mx-2">•</span>
                                    <span>Expires: <?php echo date('M j, Y', strtotime($notice['expiry_date'])); ?></span>
                                <?php endif; ?>
                            </div>
                         <a href="view_notice.php?id=<?php echo $notice['id']; ?>" class="text-blue-600 hover:text-blue-800 font-medium">
    Read More
</a>

                        </div>
                    </div>
                <?php endwhile; ?>
            </div>
        <?php else: ?>
            <div class="text-center py-8">
                <i class="fas fa-bell-slash text-4xl text-gray-300 mb-4"></i>
                <p class="text-gray-500 text-lg">No notices available at the moment.</p>
                <p class="text-gray-400">Check back later for updates.</p>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- Notice View Modal -->
<div id="noticeModal" class="fixed inset-0 bg-gray-800 bg-opacity-75 flex items-center justify-center hidden z-50">
    <div class="bg-white rounded-lg shadow-xl w-11/12 md:w-2/3 lg:w-1/2 max-h-screen overflow-y-auto">
        <div class="p-6">
            <div class="flex justify-between items-center mb-4">
                <h3 id="modalTitle" class="text-xl font-bold text-gray-800"></h3>
                <button onclick="closeModal()" class="text-gray-500 hover:text-gray-700">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            <div class="mb-4">
                <span id="modalAudience" class="text-sm text-gray-600"></span>
                <span id="modalPriority" class="text-xs font-medium px-2.5 py-0.5 rounded-full ml-2"></span>
            </div>
            <div id="modalContent" class="prose max-w-none mb-4"></div>
            <div class="text-sm text-gray-500">
                <p>Posted by: <span id="modalAuthor"></span> on <span id="modalDate"></span></p>
                <p>Expires: <span id="modalExpiry"></span></p>
            </div>
        </div>
    </div>
</div>

<script>
// Filter notices based on selection
function filterNotices(filterType) {
    const noticeItems = document.querySelectorAll('.notice-item');
    const filterButtons = document.querySelectorAll('.filter-btn');
    
    // Update active button
    filterButtons.forEach(btn => btn.classList.remove('active'));
    event.target.classList.add('active');
    
    noticeItems.forEach(item => {
        let showItem = true;
        
        switch(filterType) {
            case 'unread':
                showItem = item.getAttribute('data-viewed') === 'false';
                break;
            case 'urgent':
                showItem = item.getAttribute('data-priority') === 'urgent';
                break;
            case 'high':
                showItem = item.getAttribute('data-priority') === 'high';
                break;
            // 'all' shows everything
        }
        
        item.style.display = showItem ? 'block' : 'none';
    });
}

// View notice in modal
// Filter notices based on selection
function filterNotices(filterType) {
    const noticeItems = document.querySelectorAll('.notice-item');
    const filterButtons = document.querySelectorAll('.filter-btn');
    
    // Update active button
    filterButtons.forEach(btn => btn.classList.remove('active'));
    event.target.classList.add('active');
    
    noticeItems.forEach(item => {
        let showItem = true;
        
        switch(filterType) {
            case 'unread':
                showItem = item.getAttribute('data-viewed') === 'false';
                break;
            case 'urgent':
                showItem = item.getAttribute('data-priority') === 'urgent';
                break;
            case 'high':
                showItem = item.getAttribute('data-priority') === 'high';
                break;
            // 'all' shows everything
        }
        
        item.style.display = showItem ? 'block' : 'none';
    });
}

// Auto-refresh notices every 5 minutes
setInterval(() => {
    window.location.reload();
}, 300000); // 5 minutes

// Close modal
function closeModal() {
    document.getElementById('noticeModal').classList.add('hidden');
}

// Auto-refresh notices every 5 minutes
setInterval(() => {
    window.location.reload();
}, 300000); // 5 minutes
</script>

<style>
.filter-btn.active {
    box-shadow: 0 0 0 2px rgba(59, 130, 246, 0.5);
}
.notice-item {
    transition: all 0.3s ease;
}
.notice-item:hover {
    box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
}
</style>

<?php
include 'include/footer.php';
?>