<?php
ob_start();
include 'include/header.php';
include '../config/conn.php';

// Include PHPMailer classes
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require '../vendor/autoload.php'; // Adjust path as needed


$teacher_id = $_SESSION['user_id'];
$success = '';
$error = '';

// First, verify the teacher exists in the teachers table
// Verify the teacher exists in users table (role = 'teacher')
$teacher_check_query = "SELECT id, full_name 
                        FROM users 
                        WHERE id = $teacher_id 
                          AND role = 'teacher' 
                          AND status = 'active'";

$teacher_check_result = mysqli_query($conn, $teacher_check_query);

if (mysqli_num_rows($teacher_check_result) == 0) {
    $error = "System error: Your teacher account is not properly configured. Please contact administration.";
} else {
    $teacher_data = mysqli_fetch_assoc($teacher_check_result);
    $teacher_name = $teacher_data['full_name'];


    // Fetch classes and sections that this teacher teaches from timetable
    $teacher_classes_query = "SELECT DISTINCT c.id, c.class_name, s.id as section_id, s.section_name 
                             FROM classes c 
                             JOIN class_schedules cs ON c.id = cs.class_id 
                             JOIN sections s ON cs.section_id = s.id
                             WHERE cs.teacher_id = $teacher_id 
                             AND c.status = 'active' 
                             ORDER BY c.class_name, s.section_name";
    $teacher_classes_result = mysqli_query($conn, $teacher_classes_query);

    // Fetch subjects that this teacher teaches
    $teacher_subjects_query = "SELECT DISTINCT s.id, s.subject_name 
                              FROM subjects s 
                              JOIN class_schedules cs ON s.id = cs.subject_id 
                              WHERE cs.teacher_id = $teacher_id 
                              AND s.status = 'active' 
                              ORDER BY s.subject_name";
    $teacher_subjects_result = mysqli_query($conn, $teacher_subjects_query);
}

// Function to send emails using PHPMailer
function sendAssignmentEmails($emails, $title, $due_date, $file_path, $description, $teacher_name) {
    $mail = new PHPMailer(true);
    
    try {
        // Server settings - Configure these based on your email provider
        $mail->isSMTP();
        $mail->Host       = 'smtp.gmail.com'; // Your SMTP server
        $mail->SMTPAuth   = true;
        $mail->Username   = 'holuwaseunisrael@gmail.com';
        $mail->Password   = 'ceae tepn tfyx oxjn'; // Use app password, not regular password
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
        $mail->Port       = 465;

        // Sender info
        $mail->setFrom('noreply@yourschool.com', 'School Management System');
        $mail->addReplyTo('teacher@yourschool.com', $teacher_name);

        // Email content
        $mail->isHTML(true);
        
        foreach ($emails as $email_data) {
            // Send to student
            if (!empty($email_data['student_email'])) {
                $mail->clearAddresses(); // Clear previous recipients
                $mail->addAddress($email_data['student_email'], $email_data['student_name']);
                
                $mail->Subject = "New Assignment: $title";
                $mail->Body = "
                    <html>
                    <head>
                        <style>
                            body { font-family: Arial, sans-serif; line-height: 1.6; }
                            .header { background-color: #f8f9fa; padding: 20px; text-align: center; }
                            .content { padding: 20px; }
                            .footer { background-color: #f8f9fa; padding: 10px; text-align: center; font-size: 12px; }
                        </style>
                    </head>
                    <body>
                        <div class='header'>
                            <h2>New Assignment Notification</h2>
                        </div>
                        <div class='content'>
                            <p>Dear " . htmlspecialchars($email_data['student_name']) . ",</p>
                            <p>A new assignment <strong>" . htmlspecialchars($title) . "</strong> has been posted by your teacher.</p>
                            <p><strong>Due Date:</strong> " . htmlspecialchars($due_date) . "</p>
                            <p><strong>Description:</strong> " . nl2br(htmlspecialchars($description)) . "</p>
                            <p>Please log in to the school portal to view complete details and submit your work.</p>
                        </div>
                        <div class='footer'>
                            <p>This is an automated message. Please do not reply to this email.</p>
                            <p>&copy; " . date('Y') . " School Management System</p>
                        </div>
                    </body>
                    </html>
                ";
                
                $mail->send();
            }
            
            // Send to parent
            if (!empty($email_data['parent_email'])) {
                $mail->clearAddresses(); // Clear previous recipients
                $mail->addAddress($email_data['parent_email'], 'Parent of ' . $email_data['student_name']);
                
                $mail->Subject = "New Assignment for Your Child: $title";
                $mail->Body = "
                    <html>
                    <head>
                        <style>
                            body { font-family: Arial, sans-serif; line-height: 1.6; }
                            .header { background-color: #f8f9fa; padding: 20px; text-align: center; }
                            .content { padding: 20px; }
                            .footer { background-color: #f8f9fa; padding: 10px; text-align: center; font-size: 12px; }
                        </style>
                    </head>
                    <body>
                        <div class='header'>
                            <h2>New Assignment Notification</h2>
                        </div>
                        <div class='content'>
                            <p>Dear Parent,</p>
                            <p>A new assignment <strong>" . htmlspecialchars($title) . "</strong> has been posted for your child " . htmlspecialchars($email_data['student_name']) . ".</p>
                            <p><strong>Due Date:</strong> " . htmlspecialchars($due_date) . "</p>
                            <p><strong>Description:</strong> " . nl2br(htmlspecialchars($description)) . "</p>
                            <p>Please ensure your child completes and submits this assignment on time.</p>
                        </div>
                        <div class='footer'>
                            <p>This is an automated message. Please do not reply to this email.</p>
                            <p>&copy; " . date('Y') . " School Management System</p>
                        </div>
                    </body>
                    </html>
                ";
                
                $mail->send();
            }
        }
        
        return true;
    } catch (Exception $e) {
        error_log("Mailer Error: {$mail->ErrorInfo}");
        return false;
    }
}

// Handle assignment submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['create_assignment']) && empty($error)) {
    $class_id = intval($_POST['class_id']);
    $section_id = intval($_POST['section_id']);
    $subject_id = intval($_POST['subject_id']);
    $title = mysqli_real_escape_string($conn, $_POST['title']);
    $description = mysqli_real_escape_string($conn, $_POST['description']);
    $due_date = mysqli_real_escape_string($conn, $_POST['due_date']);
    $max_marks = isset($_POST['max_marks']) ? floatval($_POST['max_marks']) : 0;
    
    // Validate teacher authorization for this class, section, and subject
    $auth_query = "SELECT COUNT(*) as count FROM class_schedules 
                  WHERE teacher_id = $teacher_id 
                  AND class_id = $class_id 
                  AND section_id = $section_id 
                  AND subject_id = $subject_id";
    $auth_result = mysqli_query($conn, $auth_query);
    $auth_count = mysqli_fetch_assoc($auth_result)['count'];
    
    if ($auth_count == 0) {
        $error = "You are not authorized to create assignments for this class/subject combination.";
    } else if (empty($class_id) || empty($section_id) || empty($subject_id) || empty($title) || empty($due_date)) {
        $error = "Please fill all required fields.";
    } else {
        // Handle file upload
        $file_path = '';
        if (isset($_FILES['assignment_file']) && $_FILES['assignment_file']['error'] == 0) {
            $allowed_extensions = array('pdf', 'doc', 'docx', 'txt', 'jpg', 'jpeg', 'png');
            $file_name = $_FILES['assignment_file']['name'];
            $file_size = $_FILES['assignment_file']['size'];
            $file_tmp = $_FILES['assignment_file']['tmp_name'];
            $file_type = $_FILES['assignment_file']['type'];
            $file_ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));
            
            if (in_array($file_ext, $allowed_extensions)) {
                if ($file_size < 5000000) { // 5MB max
                    $new_file_name = uniqid() . '_' . time() . '.' . $file_ext;
                    $upload_path = '../uploads/assignments/' . $new_file_name;
                    
                    // Create directory if it doesn't exist
                    if (!file_exists('../uploads/assignments/')) {
                        mkdir('../uploads/assignments/', 0777, true);
                    }
                    
                    if (move_uploaded_file($file_tmp, $upload_path)) {
                        $file_path = mysqli_real_escape_string($conn, $new_file_name);
                    } else {
                        $error = "Error uploading file.";
                    }
                } else {
                    $error = "File size must be less than 5MB.";
                }
            } else {
                $error = "Invalid file type. Allowed: " . implode(', ', $allowed_extensions);
            }
        }
        
        if (empty($error)) {
            // Begin transaction
            mysqli_begin_transaction($conn);
            
            try {
                // Insert assignment into database
                $insert_query = "INSERT INTO assignments (teacher_id, class_id, section_id, subject_id, title, description, file_path, due_date, max_marks, created_at) 
                                 VALUES ($teacher_id, $class_id, $section_id, $subject_id, '$title', '$description', '$file_path', '$due_date', $max_marks, NOW())";
                
                if (mysqli_query($conn, $insert_query)) {
                    $assignment_id = mysqli_insert_id($conn);
                    
                    // Get all students in the class and section
                    $students_query = "
    SELECT 
        s.id, 
        s.student_id, 
        s.full_name, 
        s.email,
        COALESCE(s.father_email, s.mother_email, s.guardian_email) AS parent_email
    FROM students AS s
    WHERE s.class = '$class_id' 
      AND s.section = '$section_id' 
      AND s.status = 'active'
";
                    $students_result = mysqli_query($conn, $students_query);
                    
                    // Create notifications and prepare emails
                    $notifications = [];
                    $emails = [];
                    
                    while ($student = mysqli_fetch_assoc($students_result)) {
                        // Add to notifications table
                        $notification_message = "New assignment: $title. Due: $due_date";
                        $notification_query = "INSERT INTO notifications (user_id, user_type, title, message, related_id, type, created_at) 
                                              VALUES (" . $student['id'] . ", 'student', 'New Assignment', '$notification_message', $assignment_id, 'assignment', NOW())";
                        mysqli_query($conn, $notification_query);
                        
                        // Prepare email data
                        if (!empty($student['email']) || !empty($student['parent_email'])) {
                            $emails[] = [
                                'student_email' => $student['email'],
                                'parent_email' => $student['parent_email'],
                                'student_name' => $student['full_name'],
                                'assignment_title' => $title,
                                'due_date' => $due_date
                            ];
                        }
                    }
                    
                    // Commit transaction
                    mysqli_commit($conn);
                    
                    // Send emails using PHPMailer
                    $email_result = sendAssignmentEmails($emails, $title, $due_date, $file_path, $description, $teacher_name);
                    
                    if ($email_result) {
                        $success = "Assignment created successfully and notifications sent!";
                    } else {
                        $success = "Assignment created successfully, but there was an issue sending email notifications.";
                    }
                    
                } else {
                    throw new Exception("Error creating assignment: " . mysqli_error($conn));
                }
                
            } catch (Exception $e) {
                // Rollback transaction on error
                mysqli_rollback($conn);
                $error = $e->getMessage();
                
                // Delete uploaded file if assignment creation failed
                if (!empty($file_path) && file_exists('../uploads/assignments/' . $file_path)) {
                    unlink('../uploads/assignments/' . $file_path);
                }
            }
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Create Assignment - School Management System</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="bg-gray-50">
<div class="container mx-auto px-4 py-8">
    <div class="bg-white p-6  ">
        <div class="flex justify-between items-center mb-6">
            <h2 class="text-2xl font-bold text-gray-800">Create Assignment</h2>
            <div class="text-sm text-gray-600">
                <i class="fas fa-user-tie mr-1"></i> Teacher: <?php echo $_SESSION['full_name']; ?>
            </div>
        </div>

        <?php if (!empty($success)): ?>
            <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
                <?php echo $success; ?>
            </div>
        <?php endif; ?>
        
        <?php if (!empty($error)): ?>
            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                <?php echo $error; ?>
            </div>
        <?php endif; ?>

        <!-- Assignment Creation Form -->
        <div class="mb-6 bg-gray-50 p-4 ">
            <form method="POST" action="" enctype="multipart/form-data" class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <!-- Class and Section Selection -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Select Class & Section</label>
                    <select name="class_section" id="class_section" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                        <option value="">Select Class & Section</option>
                        <?php 
                        if (isset($teacher_classes_result) && mysqli_num_rows($teacher_classes_result) > 0) {
                            mysqli_data_seek($teacher_classes_result, 0);
                            while ($class = mysqli_fetch_assoc($teacher_classes_result)): 
                        ?>
                            <option value="<?php echo $class['id'] . '_' . $class['section_id']; ?>">
                                <?php echo $class['class_name'] . ' - ' . $class['section_name']; ?>
                            </option>
                        <?php 
                            endwhile;
                        } else {
                            echo '<option value="" disabled>No classes assigned</option>';
                        }
                        ?>
                    </select>
                    <input type="hidden" name="class_id" id="class_id">
                    <input type="hidden" name="section_id" id="section_id">
                </div>
                
                <!-- Subject Selection -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Select Subject</label>
                    <select name="subject_id" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                        <option value="">Select Subject</option>
                        <?php 
                        if (isset($teacher_subjects_result) && mysqli_num_rows($teacher_subjects_result) > 0) {
                            mysqli_data_seek($teacher_subjects_result, 0);
                            while ($subject = mysqli_fetch_assoc($teacher_subjects_result)): 
                        ?>
                            <option value="<?php echo $subject['id']; ?>">
                                <?php echo $subject['subject_name']; ?>
                            </option>
                        <?php 
                            endwhile;
                        } else {
                            echo '<option value="" disabled>No subjects assigned</option>';
                        }
                        ?>
                    </select>
                </div>
                
                <!-- Assignment Title -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Assignment Title</label>
                    <input type="text" name="title" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                </div>
                
                <!-- Due Date -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Due Date</label>
                    <input type="datetime-local" name="due_date" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                </div>
                
                <!-- Max Marks -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Maximum Marks (optional)</label>
                    <input type="number" name="max_marks" step="0.01" min="0" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>
                
                <!-- File Upload -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Assignment File (optional)</label>
                    <input type="file" name="assignment_file" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <p class="text-xs text-gray-500 mt-1">Allowed formats: PDF, DOC, DOCX, TXT, JPG, PNG (Max 5MB)</p>
                </div>
                
                <!-- Description -->
                <div class="md:col-span-2">
                    <label class="block text-sm font-medium text-gray-700 mb-1">Description</label>
                    <textarea name="description" rows="4" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500"></textarea>
                </div>
                
                <!-- Submit Button -->
                <div class="md:col-span-2 flex justify-center mt-4">
                    <button type="submit" name="create_assignment" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2  flex items-center">
                        <i class="fas fa-plus-circle mr-2"></i> Create Assignment
                    </button>
                </div>
            </form>
        </div>

        <!-- Existing Assignments Section -->
        <div class="bg-white p-4  ">
            <h3 class="text-lg font-semibold text-gray-800 mb-4">Recent Assignments</h3>
            
            <?php
            if (empty($error)) {
                // Fetch recent assignments created by this teacher
                $assignments_query = "SELECT a.*, c.class_name, s.section_name, sub.subject_name 
                                     FROM assignments a
                                     JOIN classes c ON a.class_id = c.id
                                     JOIN sections s ON a.section_id = s.id
                                     JOIN subjects sub ON a.subject_id = sub.id
                                     WHERE a.teacher_id = $teacher_id 
                                     ORDER BY a.created_at DESC 
                                     LIMIT 5";
                $assignments_result = mysqli_query($conn, $assignments_query);
                
                if (mysqli_num_rows($assignments_result) > 0): ?>
                    <div class="overflow-x-auto">
                        <table class="min-w-full bg-white">
                            <thead class="bg-gray-200 text-gray-700">
                                <tr>
                                    <th class="py-3 px-4 text-left">Title</th>
                                    <th class="py-3 px-4 text-left">Class</th>
                                    <th class="py-3 px-4 text-left">Subject</th>
                                    <th class="py-3 px-4 text-left">Due Date</th>
                                    <th class="py-3 px-4 text-left">Actions</th>
                                </tr>
                            </thead>
                            <tbody class="text-gray-600">
                                <?php while ($assignment = mysqli_fetch_assoc($assignments_result)): ?>
                                    <tr class="border-b border-gray-200 hover:bg-gray-50">
                                        <td class="py-3 px-4"><?php echo $assignment['title']; ?></td>
                                        <td class="py-3 px-4"><?php echo $assignment['class_name'] . ' - ' . $assignment['section_name']; ?></td>
                                        <td class="py-3 px-4"><?php echo $assignment['subject_name']; ?></td>
                                        <td class="py-3 px-4"><?php echo date('M j, Y g:i A', strtotime($assignment['due_date'])); ?></td>
                                        <td class="py-3 px-4">
                                            <?php if (!empty($assignment['file_path'])): ?>
                                                <a href="../uploads/assignments/<?php echo $assignment['file_path']; ?>" 
                                                   class="text-blue-600 hover:text-blue-800 mr-2" download>
                                                    <i class="fas fa-download"></i> Download
                                                </a>
                                            <?php endif; ?>
                                            <a href="view_assignment.php?id=<?php echo $assignment['id']; ?>" 
                                               class="text-green-600 hover:text-green-800">
                                                <i class="fas fa-eye"></i> View
                                            </a>
                                        </td>
                                    </tr>
                                <?php endwhile; ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <p class="text-center py-4 text-gray-500">
                        You haven't created any assignments yet.
                    </p>
                <?php endif;
            } else {
                echo '<p class="text-center py-4 text-gray-500">Cannot load assignments due to account configuration issue.</p>';
            }
            ?>
        </div>
    </div>
</div>

<script>
// JavaScript to handle class/section selection
document.getElementById('class_section').addEventListener('change', function() {
    const values = this.value.split('_');
    if (values.length === 2) {
        document.getElementById('class_id').value = values[0];
        document.getElementById('section_id').value = values[1];
    }
});
</script>

</body>
</html>

<?php
include 'include/footer.php';
ob_end_flush();
?>