<?php
include 'include/header.php';
include '../config/conn.php';

// Check if user is logged in and is a teacher
if (!isset($_SESSION['user_id']) || !isset($_SESSION['user_type']) || $_SESSION['user_type'] !== 'teacher') {
    header('Location: ../portal_login.php');
    exit();
}

$teacher_id = $_SESSION['user_id'];

// --- Pagination setup ---
$limit = 5; // events per page
$page = isset($_GET['page']) && is_numeric($_GET['page']) ? (int) $_GET['page'] : 1;
$offset = ($page - 1) * $limit;

// --- Count total events ---
$count_sql = "SELECT COUNT(*) as total FROM events WHERE audience_type = 'teacher' OR audience_type = 'all'";
$count_result = $conn->query($count_sql);
$total_events = $count_result->fetch_assoc()['total'];
$total_pages = ceil($total_events / $limit);

// --- Fetch events for current page ---
$sql = "SELECT * FROM events 
        WHERE audience_type = 'teacher' OR audience_type = 'all' 
        ORDER BY event_date ASC, start_time ASC 
        LIMIT ? OFFSET ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("ii", $limit, $offset);
$stmt->execute();
$result = $stmt->get_result();
$events = $result->fetch_all(MYSQLI_ASSOC);
$stmt->close();
?>

<div class="bg-white p-6">
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-2xl font-bold text-gray-800">Upcoming Events</h2>
    </div>

    <div class="space-y-4">
        <?php if (!empty($events)): ?>
            <?php foreach ($events as $event): ?>
                <div class="p-4 border border-gray-200 rounded-lg hover:bg-gray-50 transition-colors">
                    <div class="flex items-start space-x-4">
                        <!-- Date Badge -->
                        <div class="flex-shrink-0 w-14 h-14 bg-blue-100 rounded-lg flex flex-col items-center justify-center">
                            <span class="text-blue-600 font-bold text-lg">
                                <?php echo date('d', strtotime($event['event_date'])); ?>
                            </span>
                            <span class="text-xs text-gray-500">
                                <?php echo date('M', strtotime($event['event_date'])); ?>
                            </span>
                        </div>

                        <!-- Event Details -->
                        <div class="flex-1">
                           <h3 class="text-lg font-semibold text-gray-800">
    <a href="view_event_detail.php?id=<?php echo $event['id']; ?>" 
       class="text-blue-600 hover:underline">
       <?php echo htmlspecialchars($event['title']); ?>
    </a>
</h3>

                          
                            <div class="mt-2 text-xs text-gray-500">
                                <p><i class="fas fa-clock mr-1"></i> 
                                    <?php echo date('g:i A', strtotime($event['start_time'])); ?> 
                                    - <?php echo date('g:i A', strtotime($event['end_time'])); ?>
                                </p>
                                <p><i class="fas fa-map-marker-alt mr-1"></i> 
                                    <?php echo htmlspecialchars($event['location']); ?>
                                </p>
                            </div>
                        </div>

                        <!-- Optional Image -->
                        <?php if (!empty($event['image_path'])): ?>
                            <div class="w-20 h-20 flex-shrink-0">
                                <img src="../uploads/events/<?php echo htmlspecialchars($event['image_path']); ?>" 
                                     alt="Event Image" 
                                     class="w-full h-full object-cover rounded-md border">
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php else: ?>
            <p class="text-gray-500 text-center py-6">No upcoming events found.</p>
        <?php endif; ?>
    </div>

    <!-- Pagination Controls -->
    <?php if ($total_pages > 1): ?>
        <div class="mt-6 flex justify-center space-x-2">
            <?php if ($page > 1): ?>
                <a href="?page=<?php echo $page - 1; ?>" 
                   class="px-3 py-1 border rounded bg-gray-100 hover:bg-gray-200">Prev</a>
            <?php endif; ?>

            <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                <a href="?page=<?php echo $i; ?>" 
                   class="px-3 py-1 border rounded <?php echo ($i == $page) ? 'bg-blue-500 text-white' : 'bg-gray-100 hover:bg-gray-200'; ?>">
                   <?php echo $i; ?>
                </a>
            <?php endfor; ?>

            <?php if ($page < $total_pages): ?>
                <a href="?page=<?php echo $page + 1; ?>" 
                   class="px-3 py-1 border rounded bg-gray-100 hover:bg-gray-200">Next</a>
            <?php endif; ?>
        </div>
    <?php endif; ?>
</div>

<?php include 'include/footer.php'; ?>
