<?php
ob_start();
include 'include/header.php';
include '../config/conn.php';

// Check if user is logged in and is a teacher
if (!isset($_SESSION['user_id']) || !isset($_SESSION['user_type']) || $_SESSION['user_type'] !== 'teacher') {
    header('Location: login.php');
    exit();
}

$teacher_id = $_SESSION['user_id'];
$success = '';
$error = '';

// Get teacher details
$teacher_query = "SELECT u.full_name, u.email, u.teacher_id 
                 FROM users u 
                 WHERE u.id = $teacher_id AND u.role = 'teacher'";
$teacher_result = mysqli_query($conn, $teacher_query);
$teacher = mysqli_fetch_assoc($teacher_result);

// Get leave types
$leave_types_query = "SELECT * FROM leave_types WHERE status = 'active'";
$leave_types_result = mysqli_query($conn, $leave_types_query);
$leave_types = [];
while ($type = mysqli_fetch_assoc($leave_types_result)) {
    $leave_types[] = $type;
}

// Handle leave application submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['apply_leave'])) {
        $leave_type_id = intval($_POST['leave_type_id']);
        $start_date = mysqli_real_escape_string($conn, $_POST['start_date']);
        $end_date = mysqli_real_escape_string($conn, $_POST['end_date']);
        $reason = mysqli_real_escape_string($conn, $_POST['reason']);
        $emergency_contact = mysqli_real_escape_string($conn, $_POST['emergency_contact']);
        
        // Validate inputs
        if (empty($leave_type_id) || empty($start_date) || empty($end_date) || empty($reason)) {
            $error = "Please fill all required fields.";
        } else {
            // Calculate number of days (excluding weekends)
            $start = new DateTime($start_date);
            $end = new DateTime($end_date);
            $end->modify('+1 day'); // Include end date in calculation
            $interval = $start->diff($end);
            $days = $interval->days;
            
            // Subtract weekends
            $weekendDays = 0;
            for ($i = 0; $i < $days; $i++) {
                $modDate = $start->format('N');
                if ($modDate == 6 || $modDate == 7) { // 6=Saturday, 7=Sunday
                    $weekendDays++;
                }
                $start->modify('+1 day');
            }
            $working_days = $days - $weekendDays;
            
            // Insert leave application
            $insert_query = "INSERT INTO leave_applications 
                            (teacher_id, leave_type_id, start_date, end_date, working_days, reason, emergency_contact, status, applied_at) 
                            VALUES ($teacher_id, $leave_type_id, '$start_date', '$end_date', $working_days, '$reason', '$emergency_contact', 'pending', NOW())";
            
            if (mysqli_query($conn, $insert_query)) {
                $success = "Leave application submitted successfully!";
                
                // Reset form
                $_POST = [];
                
                // Refresh page to update history
                header("Location: " . $_SERVER['PHP_SELF']);
                exit();
            } else {
                $error = "Error submitting leave application: " . mysqli_error($conn);
            }
        }
    }
    
    // Handle leave deletion
    if (isset($_POST['delete_leave'])) {
        $leave_id = intval($_POST['leave_id']);
        
        // Check if the leave application belongs to the teacher and is pending
        $check_query = "SELECT * FROM leave_applications WHERE id = $leave_id AND teacher_id = $teacher_id AND status = 'pending'";
        $check_result = mysqli_query($conn, $check_query);
        
        if (mysqli_num_rows($check_result) > 0) {
            $delete_query = "DELETE FROM leave_applications WHERE id = $leave_id";
            if (mysqli_query($conn, $delete_query)) {
                $success = "Leave application deleted successfully!";
                
                // Refresh page to update history
                header("Location: " . $_SERVER['PHP_SELF']);
                exit();
            } else {
                $error = "Error deleting leave application: " . mysqli_error($conn);
            }
        } else {
            $error = "You can only delete pending leave applications.";
        }
    }
}

// Get teacher's leave history
$leave_history_query = "SELECT la.*, lt.type_name, lt.type_code
                       FROM leave_applications la
                       JOIN leave_types lt ON la.leave_type_id = lt.id
                       WHERE la.teacher_id = $teacher_id
                       ORDER BY la.applied_at DESC
                       LIMIT 10";
$leave_history_result = mysqli_query($conn, $leave_history_query);
$leave_history = [];
while ($leave = mysqli_fetch_assoc($leave_history_result)) {
    $leave_history[] = $leave;
}
?>


    <style>
        .leave-status {
            padding: 0.25rem 0.5rem;
            border-radius: 0.25rem;
            font-size: 0.75rem;
            font-weight: 500;
        }
        .status-pending {
            background-color: #fef3c7;
            color: #92400e;
        }
        .status-approved {
            background-color: #d1fae5;
            color: #065f46;
        }
        .status-rejected {
            background-color: #fee2e2;
            color: #b91c1c;
        }
        
        .calendar-day {
            width: 100%;
            height: 40px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 0.25rem;
            font-weight: 500;
        }
        
        .day-present {
            background-color: #d1fae5;
            color: #065f46;
        }
        
        .day-absent {
            background-color: #fee2e2;
            color: #b91c1c;
        }
        
        .day-weekend {
            background-color: #f3f4f6;
            color: #6b7280;
        }
        
        .day-future {
            background-color: #ffffff;
            color: #9ca3af;
            border: 1px solid #e5e7eb;
        }
    </style>
</head>
<body class="bg-gray-100">
    <div class="container mx-auto px-4 py-2">
        <div class="bg-white p-6  ">
            <div class="flex justify-between items-center mb-6">
                <div>
                    <h2 class="text-2xl font-bold text-gray-800">Teacher Leave Application</h2>
                    <p class="text-gray-600"><?php echo $teacher['full_name']; ?> (ID: <?php echo $teacher['teacher_id']; ?>)</p>
                </div>
                <a href="dashboard.php" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 ">
                    <i class="fas fa-arrow-left mr-2"></i> Back to Dashboard
                </a>
            </div>

            <?php if (!empty($success)): ?>
                <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
                    <?php echo $success; ?>
                </div>
            <?php endif; ?>
            
            <?php if (!empty($error)): ?>
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                    <?php echo $error; ?>
                </div>
            <?php endif; ?>

            <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                <!-- Leave Application Form -->
                <div class="lg:col-span-2">
                    <div class="bg-white p-6  border border-gray-200">
                        <h3 class="text-lg font-semibold text-gray-800 mb-4">Apply for Leave</h3>
                        
                        <form method="POST" action="" id="leaveForm">
                            <div class="grid grid-cols-1 gap-4 mb-4">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Leave Type *</label>
                                    <select name="leave_type_id" required 
                                            class="w-full px-4 py-2 border border-gray-300  focus:outline-none focus:ring-2 focus:ring-blue-500">
                                        <option value="">Select Leave Type</option>
                                        <?php foreach ($leave_types as $type): ?>
                                            <option value="<?php echo $type['id']; ?>" 
                                                    <?php echo (isset($_POST['leave_type_id']) && $_POST['leave_type_id'] == $type['id']) ? 'selected' : ''; ?>>
                                                <?php echo $type['type_name']; ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                            
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Start Date *</label>
                                    <input type="date" name="start_date" required 
                                           value="<?php echo $_POST['start_date'] ?? ''; ?>"
                                           class="w-full px-4 py-2 border border-gray-300  focus:outline-none focus:ring-2 focus:ring-blue-500"
                                           min="<?php echo date('Y-m-d'); ?>">
                                </div>
                                
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">End Date *</label>
                                    <input type="date" name="end_date" required 
                                           value="<?php echo $_POST['end_date'] ?? ''; ?>"
                                           class="w-full px-4 py-2 border border-gray-300  focus:outline-none focus:ring-2 focus:ring-blue-500"
                                           min="<?php echo date('Y-m-d'); ?>">
                                </div>
                            </div>
                            
                            <div class="mb-4 p-3 bg-blue-50  border border-blue-200">
                                <label class="block text-sm font-medium text-blue-700 mb-1">Number of Working Days</label>
                                <div id="daysCalculation" class="px-4 py-2 bg-white  text-lg font-semibold text-blue-800 border border-blue-300">
                                    Select dates to calculate working days
                                </div>
                                <p class="text-xs text-blue-600 mt-1">Weekends (Saturday & Sunday) are excluded automatically</p>
                            </div>
                            
                            <div class="mb-4">
                                <label class="block text-sm font-medium text-gray-700 mb-1">Reason for Leave *</label>
                                <textarea name="reason" required rows="4"
                                          class="w-full px-4 py-2 border border-gray-300  focus:outline-none focus:ring-2 focus:ring-blue-500"
                                          placeholder="Please provide details about your leave"><?php echo $_POST['reason'] ?? ''; ?></textarea>
                            </div>
                            
                            <div class="mb-4">
                                <label class="block text-sm font-medium text-gray-700 mb-1">Emergency Contact</label>
                                <input type="text" name="emergency_contact" 
                                       value="<?php echo $_POST['emergency_contact'] ?? ''; ?>"
                                       class="w-full px-4 py-2 border border-gray-300  focus:outline-none focus:ring-2 focus:ring-blue-500"
                                       placeholder="Phone number for emergency contact">
                            </div>
                            
                            <div class="flex justify-end mt-6">
                                <button type="submit" name="apply_leave" 
                                        class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 ">
                                    <i class="fas fa-paper-plane mr-2"></i> Submit Application
                                </button>
                            </div>
                        </form>
                    </div>
                    
                    <!-- Mini Calendar View -->
                    <div class="bg-white p-6  border border-gray-200 mt-6">
                        <h3 class="text-lg font-semibold text-gray-800 mb-4">This Month</h3>
                        <div class="grid grid-cols-7 gap-2">
                            <?php
                            // Generate a mini calendar for the current month
                            $currentMonth = date('Y-m');
                            $daysInMonth = date('t', strtotime($currentMonth));
                            $firstDay = date('N', strtotime($currentMonth . '-01'));
                            
                            // Day headers
                            $dayNames = ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'];
                            foreach ($dayNames as $day) {
                                echo '<div class="text-center text-xs font-medium text-gray-500 py-1">' . $day . '</div>';
                            }
                            
                            // Empty cells for days before the first day of the month
                            for ($i = 1; $i < $firstDay; $i++) {
                                echo '<div class="calendar-day day-future"></div>';
                            }
                            
                            // Days of the month
                            for ($day = 1; $day <= $daysInMonth; $day++) {
                                $currentDate = date('Y-m-d', strtotime($currentMonth . '-' . sprintf('%02d', $day)));
                                $isWeekend = (date('N', strtotime($currentDate)) >= 6);
                                $isFuture = (strtotime($currentDate) > time());
                                
                                $dayClass = $isWeekend ? 'day-weekend' : ($isFuture ? 'day-future' : 'day-present');
                                
                                echo '<div class="calendar-day ' . $dayClass . '">' . $day . '</div>';
                            }
                            ?>
                        </div>
                    </div>
                </div>
                
                <!-- Leave History -->
                <div class="space-y-6">
                    <!-- Recent Applications -->
                    <div class="bg-white p-6  border border-gray-200">
                        <h3 class="text-lg font-semibold text-gray-800 mb-4">Recent Applications</h3>
                        
                        <?php if (!empty($leave_history)): ?>
                            <div class="space-y-3">
                                <?php foreach ($leave_history as $leave): ?>
                                    <div class="p-3 border ">
                                        <div class="flex justify-between items-center mb-2">
                                            <span class="font-medium"><?php echo $leave['type_name']; ?></span>
                                            <span class="leave-status status-<?php echo $leave['status']; ?>">
                                                <?php echo ucfirst($leave['status']); ?>
                                            </span>
                                        </div>
                                        
                                        <div class="text-sm text-gray-600 mb-2">
                                            <?php echo date('M j, Y', strtotime($leave['start_date'])); ?> 
                                            to 
                                            <?php echo date('M j, Y', strtotime($leave['end_date'])); ?>
                                            (<?php echo $leave['working_days']; ?> days)
                                        </div>
                                        
                                        <div class="text-xs text-gray-500">
                                            Applied: <?php echo date('M j, Y g:i A', strtotime($leave['applied_at'])); ?>
                                        </div>
                                        
                                        <?php if ($leave['status'] === 'pending'): ?>
                                            <div class="mt-2 flex justify-end">
                                                <form method="POST" action="">
                                                    <input type="hidden" name="leave_id" value="<?php echo $leave['id']; ?>">
                                                    <button type="submit" name="delete_leave" 
                                                            class="text-red-600 hover:text-red-800 text-sm"
                                                            onclick="return confirm('Are you sure you want to delete this leave application?')">
                                                        <i class="fas fa-trash mr-1"></i> Delete
                                                    </button>
                                                </form>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        <?php else: ?>
                            <p class="text-gray-500 text-sm">No leave applications yet.</p>
                        <?php endif; ?>
                        
                        <div class="mt-4 text-center">
                            <a href="leave_history.php" class="text-blue-600 hover:text-blue-800 text-sm">
                                View All Applications <i class="fas fa-arrow-right ml-1"></i>
                            </a>
                        </div>
                    </div>
                    
                    <!-- Quick Stats -->
                    <div class="bg-white p-6  border border-gray-200">
                        <h3 class="text-lg font-semibold text-gray-800 mb-4">Application Status</h3>
                        <div class="grid grid-cols-2 gap-4">
                            <div class="text-center p-3 bg-blue-50 ">
                                <div class="text-2xl font-bold text-blue-600">
                                    <?php
                                    $pending_query = "SELECT COUNT(*) as count FROM leave_applications WHERE teacher_id = $teacher_id AND status = 'pending'";
                                    $pending_result = mysqli_query($conn, $pending_query);
                                    $pending = mysqli_fetch_assoc($pending_result)['count'];
                                    echo $pending;
                                    ?>
                                </div>
                                <div class="text-sm text-blue-800">Pending</div>
                            </div>
                            <div class="text-center p-3 bg-green-50 ">
                                <div class="text-2xl font-bold text-green-600">
                                    <?php
                                    $approved_query = "SELECT COUNT(*) as count FROM leave_applications WHERE teacher_id = $teacher_id AND status = 'approved'";
                                    $approved_result = mysqli_query($conn, $approved_query);
                                    $approved = mysqli_fetch_assoc($approved_result)['count'];
                                    echo $approved;
                                    ?>
                                </div>
                                <div class="text-sm text-green-800">Approved</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
    // Calculate working days between dates
    function calculateWorkingDays(startDate, endDate) {
        if (!startDate || !endDate) return 0;
        
        const start = new Date(startDate);
        const end = new Date(endDate);
        end.setDate(end.getDate() + 1); // Include end date
        
        let count = 0;
        const curDate = new Date(start.getTime());
        
        while (curDate < end) {
            const dayOfWeek = curDate.getDay();
            if (dayOfWeek !== 0 && dayOfWeek !== 6) { // Skip weekends
                count++;
            }
            curDate.setDate(curDate.getDate() + 1);
        }
        
        return count;
    }

    // Update days calculation when dates change
    document.querySelectorAll('input[type="date"]').forEach(input => {
        input.addEventListener('change', updateDaysCalculation);
    });

    function updateDaysCalculation() {
        const startDate = document.querySelector('input[name="start_date"]').value;
        const endDate = document.querySelector('input[name="end_date"]').value;
        
        if (startDate && endDate) {
            const workingDays = calculateWorkingDays(startDate, endDate);
            document.getElementById('daysCalculation').innerHTML = 
                '<span class="text-2xl">' + workingDays + '</span> working day' + (workingDays !== 1 ? 's' : '');
        } else {
            document.getElementById('daysCalculation').innerHTML = 'Select dates to calculate working days';
        }
    }

    // Form validation
    document.getElementById('leaveForm').addEventListener('submit', function(e) {
        const startDate = new Date(document.querySelector('input[name="start_date"]').value);
        const endDate = new Date(document.querySelector('input[name="end_date"]').value);
        const leaveType = document.querySelector('select[name="leave_type_id"]').value;
        
        if (!leaveType) {
            e.preventDefault();
            alert('Please select a leave type.');
            return false;
        }
        
        if (startDate > endDate) {
            e.preventDefault();
            alert('End date cannot be before start date.');
            return false;
        }
    });

    // Initialize calculations on page load
    document.addEventListener('DOMContentLoaded', function() {
        updateDaysCalculation();
    });
    </script>
</body>
</html>

<?php
include 'include/footer.php';
ob_end_flush();
?>