<?php
// Add this at the top of your PHP code for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);
ob_start();
include 'include/header.php';
include '../config/conn.php';

// Check if user is logged in and is a teacher


$teacher_id = $_SESSION['user_id'];
$success = '';
$error = '';

// Initialize variables
$class_id = isset($_GET['class_id']) ? intval($_GET['class_id']) : 0;
$section_id = isset($_GET['section_id']) ? intval($_GET['section_id']) : 0;
$subject_id = isset($_GET['subject_id']) ? intval($_GET['subject_id']) : 0;
$lesson_id = isset($_GET['lesson_id']) ? intval($_GET['lesson_id']) : 0;
$action = isset($_GET['action']) ? $_GET['action'] : 'list';

// Fetch classes and subjects that this teacher teaches from timetable
$teacher_classes_query = "SELECT DISTINCT c.id, c.class_name 
                         FROM classes c 
                         JOIN class_schedules cs ON c.id = cs.class_id 
                         WHERE cs.teacher_id = $teacher_id 
                         AND c.status = 'active' 
                         ORDER BY c.class_name";
$teacher_classes_result = mysqli_query($conn, $teacher_classes_query);

// Fetch subjects that this teacher teaches
$teacher_subjects_query = "SELECT DISTINCT s.id, s.subject_name 
                          FROM subjects s 
                          JOIN class_schedules cs ON s.id = cs.subject_id 
                          WHERE cs.teacher_id = $teacher_id 
                          AND s.status = 'active' 
                          ORDER BY s.subject_name";
$teacher_subjects_result = mysqli_query($conn, $teacher_subjects_query);

// Fetch sections based on selected class (only if teacher teaches that class)
$sections = [];
if ($class_id > 0) {
    // Verify teacher teaches this class
    $verify_class_query = "SELECT COUNT(*) as count FROM class_schedules 
                          WHERE teacher_id = $teacher_id AND class_id = $class_id";
    $verify_class_result = mysqli_query($conn, $verify_class_query);
    $class_count = mysqli_fetch_assoc($verify_class_result)['count'];
    
    if ($class_count > 0) {
        $sections_query = "SELECT id, section_name FROM sections 
                          WHERE class_id = $class_id AND status = 'active' 
                          ORDER BY section_name";
        $sections_result = mysqli_query($conn, $sections_query);
        while ($section = mysqli_fetch_assoc($sections_result)) {
            $sections[] = $section;
        }
    } else {
        $error = "You are not assigned to teach this class.";
        $class_id = 0; // Reset class selection
    }
}

// Verify teacher teaches the selected subject
if ($subject_id > 0) {
    $verify_subject_query = "SELECT COUNT(*) as count FROM class_schedules 
                            WHERE teacher_id = $teacher_id 
                            AND subject_id = $subject_id";
    $verify_subject_result = mysqli_query($conn, $verify_subject_query);
    $subject_count = mysqli_fetch_assoc($verify_subject_result)['count'];
    
    if ($subject_count == 0) {
        $error = "You are not assigned to teach this subject.";
        $subject_id = 0; // Reset subject selection
    }
}

// Handle lesson note creation/editing
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
     error_log("Form submitted with data: " . print_r($_POST, true));
    if (isset($_POST['create_lesson'])) {
        $topic = mysqli_real_escape_string($conn, $_POST['topic']);
        $subject_id = intval($_POST['subject_id']);
        $class_id = intval($_POST['class_id']);
        $section_id = isset($_POST['section_id']) && !empty($_POST['section_id']) ? intval($_POST['section_id']) : NULL;
        $date_taught = $_POST['date_taught'];
        $duration = intval($_POST['duration']);
        $objectives = mysqli_real_escape_string($conn, $_POST['objectives']);
        $materials = mysqli_real_escape_string($conn, $_POST['materials']);
        $introduction = mysqli_real_escape_string($conn, $_POST['introduction']);
        $presentation = mysqli_real_escape_string($conn, $_POST['presentation']);
        $practice = mysqli_real_escape_string($conn, $_POST['practice']);
        $evaluation = mysqli_real_escape_string($conn, $_POST['evaluation']);
        $conclusion = mysqli_real_escape_string($conn, $_POST['conclusion']);
        $homework = mysqli_real_escape_string($conn, $_POST['homework']);
        $status = $_POST['status'];
        
        // Validate teacher authorization for this class and subject
        $auth_query = "SELECT COUNT(*) as count FROM class_schedules 
                      WHERE teacher_id = $teacher_id 
                      AND class_id = $class_id 
                      AND subject_id = $subject_id";
        if ($section_id) {
            $auth_query .= " AND section_id = $section_id";
        }
        
        $auth_result = mysqli_query($conn, $auth_query);
        $auth_count = mysqli_fetch_assoc($auth_result)['count'];
        
        if ($auth_count == 0) {
            $error = "You are not authorized to create lesson notes for this class/subject combination.";
        } else if (empty($topic) || empty($subject_id) || empty($class_id) || empty($date_taught)) {
            $error = "Please fill in all required fields.";
        } else {
            $insert_query = "INSERT INTO lesson_notes (topic, subject_id, class_id, section_id, date_taught, duration, 
                                 objectives, materials, introduction, presentation, practice, evaluation, 
                                 conclusion, homework, status, created_by, created_at) 
                             VALUES ('$topic', $subject_id, $class_id, " . 
                             ($section_id ? "$section_id" : "NULL") . ", '$date_taught', $duration, 
                             '$objectives', '$materials', '$introduction', '$presentation', '$practice', 
                             '$evaluation', '$conclusion', '$homework', '$status', 
                             $teacher_id, NOW())";
            
            if (mysqli_query($conn, $insert_query)) {
                $lesson_id = mysqli_insert_id($conn);
                $success = "Lesson note created successfully!";
                $action = 'view';
            } else {
                $error = "Error creating lesson note: " . mysqli_error($conn);
            }
        }
    } 
    elseif (isset($_POST['update_lesson'])) {
        $lesson_id = intval($_POST['lesson_id']);
        $topic = mysqli_real_escape_string($conn, $_POST['topic']);
        $subject_id = intval($_POST['subject_id']);
        $class_id = intval($_POST['class_id']);
        $section_id = isset($_POST['section_id']) && !empty($_POST['section_id']) ? intval($_POST['section_id']) : NULL;
        $date_taught = $_POST['date_taught'];
        $duration = intval($_POST['duration']);
        $objectives = mysqli_real_escape_string($conn, $_POST['objectives']);
        $materials = mysqli_real_escape_string($conn, $_POST['materials']);
        $introduction = mysqli_real_escape_string($conn, $_POST['introduction']);
        $presentation = mysqli_real_escape_string($conn, $_POST['presentation']);
        $practice = mysqli_real_escape_string($conn, $_POST['practice']);
        $evaluation = mysqli_real_escape_string($conn, $_POST['evaluation']);
        $conclusion = mysqli_real_escape_string($conn, $_POST['conclusion']);
        $homework = mysqli_real_escape_string($conn, $_POST['homework']);
        $status = $_POST['status'];
        
        // Validate teacher authorization for this lesson
        $lesson_auth_query = "SELECT created_by FROM lesson_notes WHERE id = $lesson_id";
        $lesson_auth_result = mysqli_query($conn, $lesson_auth_query);
        
        if (mysqli_num_rows($lesson_auth_result) === 0) {
            $error = "Lesson note not found.";
        } else {
            $lesson_owner = mysqli_fetch_assoc($lesson_auth_result)['created_by'];
            if ($lesson_owner != $teacher_id) {
                $error = "You are not authorized to edit this lesson note.";
            } else if (empty($topic) || empty($subject_id) || empty($class_id) || empty($date_taught)) {
                $error = "Please fill in all required fields.";
            } else {
                $update_query = "UPDATE lesson_notes SET 
                                topic = '$topic', 
                                subject_id = $subject_id, 
                                class_id = $class_id, 
                                section_id = " . ($section_id ? "$section_id" : "NULL") . ", 
                                date_taught = '$date_taught', 
                                duration = $duration, 
                                objectives = '$objectives', 
                                materials = '$materials', 
                                introduction = '$introduction', 
                                presentation = '$presentation', 
                                practice = '$practice', 
                                evaluation = '$evaluation', 
                                conclusion = '$conclusion', 
                                homework = '$homework', 
                                status = '$status',
                                updated_at = NOW()
                                WHERE id = $lesson_id";
                
                if (mysqli_query($conn, $update_query)) {
                    $success = "Lesson note updated successfully!";
                    $action = 'view';
                } else {
                    $error = "Error updating lesson note: " . mysqli_error($conn);
                }
            }
        }
    }
}

// Handle delete action
if (isset($_GET['delete_lesson'])) {
    $delete_id = intval($_GET['delete_lesson']);
    
    // Validate teacher authorization for this lesson
    $lesson_auth_query = "SELECT created_by FROM lesson_notes WHERE id = $delete_id";
    $lesson_auth_result = mysqli_query($conn, $lesson_auth_query);
    
    if (mysqli_num_rows($lesson_auth_result) === 0) {
        $error = "Lesson note not found.";
    } else {
        $lesson_owner = mysqli_fetch_assoc($lesson_auth_result)['created_by'];
        if ($lesson_owner != $teacher_id) {
            $error = "You are not authorized to delete this lesson note.";
        } else {
            $delete_query = "DELETE FROM lesson_notes WHERE id = $delete_id";
            if (mysqli_query($conn, $delete_query)) {
                $success = "Lesson note deleted successfully!";
            } else {
                $error = "Error deleting lesson note: " . mysqli_error($conn);
            }
        }
    }
}

// Get class, section, and subject names for display
$class_name = '';
$section_name = '';
$subject_name = '';

if ($class_id > 0) {
    $class_name_query = "SELECT class_name FROM classes WHERE id = $class_id";
    $class_name_result = mysqli_query($conn, $class_name_query);
    if ($class_name_result && mysqli_num_rows($class_name_result) > 0) {
        $class_name = mysqli_fetch_assoc($class_name_result)['class_name'];
    }
}

if ($section_id > 0) {
    $section_name_query = "SELECT section_name FROM sections WHERE id = $section_id";
    $section_name_result = mysqli_query($conn, $section_name_query);
    if ($section_name_result && mysqli_num_rows($section_name_result) > 0) {
        $section_name = mysqli_fetch_assoc($section_name_result)['section_name'];
    }
}

if ($subject_id > 0) {
    $subject_name_query = "SELECT subject_name FROM subjects WHERE id = $subject_id";
    $subject_name_result = mysqli_query($conn, $subject_name_query);
    if ($subject_name_result && mysqli_num_rows($subject_name_result) > 0) {
        $subject_name = mysqli_fetch_assoc($subject_name_result)['subject_name'];
    }
}

// Fetch lesson notes created by this teacher based on filters
$lesson_notes = [];
$lesson_query = "SELECT ln.*, s.subject_name, c.class_name, sec.section_name 
                 FROM lesson_notes ln 
                 LEFT JOIN subjects s ON ln.subject_id = s.id 
                 LEFT JOIN classes c ON ln.class_id = c.id 
                 LEFT JOIN sections sec ON ln.section_id = sec.id 
                 WHERE ln.created_by = $teacher_id";
                 
if ($class_id > 0) {
    $lesson_query .= " AND ln.class_id = $class_id";
}
if ($section_id > 0) {
    $lesson_query .= " AND ln.section_id = $section_id";
}
if ($subject_id > 0) {
    $lesson_query .= " AND ln.subject_id = $subject_id";
}

$lesson_query .= " ORDER BY ln.date_taught DESC, ln.created_at DESC";
$lesson_result = mysqli_query($conn, $lesson_query);
while ($lesson = mysqli_fetch_assoc($lesson_result)) {
    $lesson_notes[] = $lesson;
}

// Fetch lesson details if editing or viewing
$lesson_details = [];
if ($lesson_id > 0) {
    // Validate teacher authorization for this lesson
    $lesson_auth_query = "SELECT ln.*, s.subject_name, c.class_name, sec.section_name 
                         FROM lesson_notes ln 
                         LEFT JOIN subjects s ON ln.subject_id = s.id 
                         LEFT JOIN classes c ON ln.class_id = c.id 
                         LEFT JOIN sections sec ON ln.section_id = sec.id 
                         WHERE ln.id = $lesson_id AND ln.created_by = $teacher_id";
    $lesson_result = mysqli_query($conn, $lesson_auth_query);
    if ($lesson_result && mysqli_num_rows($lesson_result) > 0) {
        $lesson_details = mysqli_fetch_assoc($lesson_result);
    } else {
        $error = "Lesson note not found or you are not authorized to access it.";
        $lesson_id = 0;
    }
}
?>

<div class="bg-white p-6 rounded-lg shadow">
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-2xl font-bold text-gray-800">Lesson Note Management</h2>
        <div class="text-sm text-gray-600">
            <i class="fas fa-user-tie mr-1"></i> Teacher: <?php echo $_SESSION['full_name']; ?>
        </div>
    </div>

    <?php if (!empty($success)): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
            <?php echo $success; ?>
        </div>
    <?php endif; ?>
    
    <?php if (!empty($error)): ?>
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
            <?php echo $error; ?>
        </div>
    <?php endif; ?>

    <?php if ($action === 'create' || $action === 'edit'): ?>
        <!-- Create/Edit Lesson Note Form -->
        <?php 
        $is_edit = ($action === 'edit' && $lesson_id > 0);
        $form_title = $is_edit ? "Edit Lesson Note: " . $lesson_details['topic'] : "Create New Lesson Note";
        $button_text = $is_edit ? "Update Lesson" : "Create Lesson";
        $form_action = $is_edit ? "teacher_lesson.php?action=edit&lesson_id=$lesson_id" : "teacher_lesson.php?action=create";
        ?>
        
        <div class="mb-6 bg-white p-6 rounded-lg border">
            <h3 class="text-xl font-semibold text-gray-800 mb-4"><?php echo $form_title; ?></h3>
            
            <form method="POST" action="<?php echo $form_action; ?>">
                <?php if ($is_edit): ?>
                    <input type="hidden" name="lesson_id" value="<?php echo $lesson_id; ?>">
                <?php endif; ?>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Topic/Title *</label>
                        <input type="text" name="topic" value="<?php echo $is_edit ? $lesson_details['topic'] : ''; ?>" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                    </div>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Subject *</label>
                        <select name="subject_id" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                            <option value="">Select Subject</option>
                            <?php 
                            if (mysqli_num_rows($teacher_subjects_result) > 0) {
                                mysqli_data_seek($teacher_subjects_result, 0);
                                while ($subject = mysqli_fetch_assoc($teacher_subjects_result)): 
                            ?>
                                <option value="<?php echo $subject['id']; ?>" <?php echo (($is_edit && $lesson_details['subject_id'] == $subject['id']) || $subject_id == $subject['id']) ? 'selected' : ''; ?>>
                                    <?php echo $subject['subject_name']; ?>
                                </option>
                            <?php 
                                endwhile;
                            } else {
                                echo '<option value="" disabled>No subjects assigned</option>';
                            }
                            ?>
                        </select>
                    </div>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Class *</label>
                        <select name="class_id" id="class_filter" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                            <option value="">Select Class</option>
                            <?php 
                            if (mysqli_num_rows($teacher_classes_result) > 0) {
                                mysqli_data_seek($teacher_classes_result, 0);
                                while ($class = mysqli_fetch_assoc($teacher_classes_result)): 
                            ?>
                                <option value="<?php echo $class['id']; ?>" <?php echo (($is_edit && $lesson_details['class_id'] == $class['id']) || $class_id == $class['id']) ? 'selected' : ''; ?>>
                                    <?php echo $class['class_name']; ?>
                                </option>
                            <?php 
                                endwhile;
                            } else {
                                echo '<option value="" disabled>No classes assigned</option>';
                            }
                            ?>
                        </select>
                    </div>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Section</label>
                        <select name="section_id" id="section_filter" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" <?php echo (($is_edit && $lesson_details['class_id'] == 0) || $class_id == 0) ? 'disabled' : ''; ?>>
                            <option value="">Select Section (Optional)</option>
                            <?php foreach ($sections as $section): ?>
                                <option value="<?php echo $section['id']; ?>" <?php echo (($is_edit && $lesson_details['section_id'] == $section['id']) || $section_id == $section['id']) ? 'selected' : ''; ?>>
                                    <?php echo $section['section_name']; ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Date Taught *</label>
                        <input type="date" name="date_taught" value="<?php echo $is_edit ? $lesson_details['date_taught'] : date('Y-m-d'); ?>" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                    </div>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Duration (minutes)</label>
                        <input type="number" name="duration" min="1" value="<?php echo $is_edit ? $lesson_details['duration'] : '40'; ?>" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                    </div>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Status</label>
                        <select name="status" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                            <option value="draft" <?php echo ($is_edit && $lesson_details['status'] == 'draft') ? 'selected' : ''; ?>>Draft</option>
                            <option value="completed" <?php echo ($is_edit && $lesson_details['status'] == 'completed') ? 'selected' : ''; ?>>Completed</option>
                        </select>
                    </div>
                </div>
                
                <div class="mb-6">
                    <label class="block text-sm font-medium text-gray-700 mb-1">Learning Objectives</label>
                    <textarea name="objectives" rows="3" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" placeholder="What should students be able to do after this lesson?"><?php echo $is_edit ? $lesson_details['objectives'] : ''; ?></textarea>
                </div>
                
                <div class="mb-6">
                    <label class="block text-sm font-medium text-gray-700 mb-1">Teaching Materials/Resources</label>
                    <textarea name="materials" rows="2" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" placeholder="Textbooks, charts, multimedia, etc."><?php echo $is_edit ? $lesson_details['materials'] : ''; ?></textarea>
                </div>
                
                <div class="mb-6">
                    <label class="block text-sm font-medium text-gray-700 mb-1">Introduction (Set Induction)</label>
                    <textarea name="introduction" rows="3" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" placeholder="How will you introduce the lesson and engage students?"><?php echo $is_edit ? $lesson_details['introduction'] : ''; ?></textarea>
                </div>
                
                <div class="mb-6">
                    <label class="block text-sm font-medium text-gray-700 mb-1">Presentation (Lesson Development)</label>
                    <textarea name="presentation" rows="4" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" placeholder="Step-by-step explanation of the main content"><?php echo $is_edit ? $lesson_details['presentation'] : ''; ?></textarea>
                </div>
                
                <div class="mb-6">
                    <label class="block text-sm font-medium text-gray-700 mb-1">Practice (Guided & Independent)</label>
                    <textarea name="practice" rows="3" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" placeholder="Activities, exercises, or questions for students"><?php echo $is_edit ? $lesson_details['practice'] : ''; ?></textarea>
                </div>
                
                <div class="mb-6">
                    <label class="block text-sm font-medium text-gray-700 mb-1">Evaluation/Assessment</label>
                    <textarea name="evaluation" rows="2" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" placeholder="How will you assess student understanding?"><?php echo $is_edit ? $lesson_details['evaluation'] : ''; ?></textarea>
                </div>
                
                <div class="mb-6">
                    <label class="block text-sm font-medium text-gray-700 mb-1">Conclusion</label>
                    <textarea name="conclusion" rows="2" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" placeholder="Summary and reinforcement of key points"><?php echo $is_edit ? $lesson_details['conclusion'] : ''; ?></textarea>
                </div>
                
                <div class="mb-6">
                    <label class="block text-sm font-medium text-gray-700 mb-1">Homework/Assignment</label>
                    <textarea name="homework" rows="2" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" placeholder="Follow-up work for students"><?php echo $is_edit ? $lesson_details['homework'] : ''; ?></textarea>
                </div>
                
                <div class="mt-6 flex justify-end space-x-3">
                    <a href="teacher_lesson.php" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-lg">
                        Cancel
                    </a>
                    <button type="submit" name="<?php echo $is_edit ? 'update_lesson' : 'create_lesson'; ?>" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg">
                        <?php echo $button_text; ?>
                    </button>
                </div>
            </form>
        </div>

    <?php elseif ($action === 'view' && $lesson_id > 0): ?>
        <!-- View Lesson Note -->
        <div class="mb-6 bg-white p-6 rounded-lg border">
            <div class="flex justify-between items-center mb-6">
                <h3 class="text-xl font-semibold text-gray-800">Lesson Note: <?php echo $lesson_details['topic']; ?></h3>
                <div class="flex space-x-2">
                    <a href="teacher_lesson.php?action=edit&lesson_id=<?php echo $lesson_id; ?>" class="bg-yellow-600 hover:bg-yellow-700 text-white px-4 py-2 rounded-lg">
                        Edit
                    </a>
                    <a href="teacher_lesson.php" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-lg">
                        Back to List
                    </a>
                </div>
            </div>
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
                <div class="bg-gray-50 p-4 rounded-lg">
                    <h4 class="font-medium text-gray-700 mb-2">Basic Information</h4>
                    <p><span class="font-semibold">Subject:</span> <?php echo $lesson_details['subject_name']; ?></p>
                    <p><span class="font-semibold">Class:</span> <?php echo $lesson_details['class_name']; ?></p>
                    <?php if ($lesson_details['section_name']): ?>
                        <p><span class="font-semibold">Section:</span> <?php echo $lesson_details['section_name']; ?></p>
                    <?php endif; ?>
                    <p><span class="font-semibold">Date:</span> <?php echo date('F j, Y', strtotime($lesson_details['date_taught'])); ?></p>
                    <p><span class="font-semibold">Duration:</span> <?php echo $lesson_details['duration']; ?> minutes</p>
                    <p><span class="font-semibold">Status:</span> 
                        <span class="px-2 py-1 text-xs font-medium rounded-full <?php echo $lesson_details['status'] === 'completed' ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800'; ?>">
                            <?php echo ucfirst($lesson_details['status']); ?>
                        </span>
                    </p>
                </div>
                
                <div class="bg-gray-50 p-4 rounded-lg">
                    <h4 class="font-medium text-gray-700 mb-2">Learning Objectives</h4>
                    <p><?php echo nl2br($lesson_details['objectives']); ?></p>
                </div>
            </div>
            
            <div class="bg-gray-50 p-4 rounded-lg mb-4">
                <h4 class="font-medium text-gray-700 mb-2">Teaching Materials/Resources</h4>
                <p><?php echo nl2br($lesson_details['materials']); ?></p>
            </div>
            
            <div class="space-y-4">
                <div class="bg-gray-50 p-4 rounded-lg">
                    <h4 class="font-medium text-gray-700 mb-2">Introduction (Set Induction)</h4>
                    <p><?php echo nl2br($lesson_details['introduction']); ?></p>
                </div>
                
                <div class="bg-gray-50 p-4 rounded-lg">
                    <h4 class="font-medium text-gray-700 mb-2">Presentation (Lesson Development)</h4>
                    <p><?php echo nl2br($lesson_details['presentation']); ?></p>
                </div>
                
                <div class="bg-gray-50 p-4 rounded-lg">
                    <h4 class="font-medium text-gray-700 mb-2">Practice (Guided & Independent)</h4>
                    <p><?php echo nl2br($lesson_details['practice']); ?></p>
                </div>
                
                <div class="bg-gray-50 p-4 rounded-lg">
                    <h4 class="font-medium text-gray-700 mb-2">Evaluation/Assessment</h4>
                    <p><?php echo nl2br($lesson_details['evaluation']); ?></p>
                </div>
                
                <div class="bg-gray-50 p-4 rounded-lg">
                    <h4 class="font-medium text-gray-700 mb-2">Conclusion</h4>
                    <p><?php echo nl2br($lesson_details['conclusion']); ?></p>
                </div>
                
                <div class="bg-gray-50 p-4 rounded-lg">
                    <h4 class="font-medium text-gray-700 mb-2">Homework/Assignment</h4>
                    <p><?php echo nl2br($lesson_details['homework']); ?></p>
                </div>
            </div>
        </div>

    <?php else: ?>
        <!-- Filter Section -->
        <div class="mb-6 bg-gray-50 p-4 rounded-lg">
            <form method="GET" action="" class="grid grid-cols-1 md:grid-cols-4 gap-4">
                <!-- Class Filter -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Select Class</label>
                    <select name="class_id" id="class_filter" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <option value="">All Classes</option>
                        <?php 
                        if (mysqli_num_rows($teacher_classes_result) > 0) {
                            mysqli_data_seek($teacher_classes_result, 0);
                            while ($class = mysqli_fetch_assoc($teacher_classes_result)): 
                        ?>
                            <option value="<?php echo $class['id']; ?>" <?php echo ($class_id == $class['id']) ? 'selected' : ''; ?>>
                                <?php echo $class['class_name']; ?>
                            </option>
                        <?php 
                            endwhile;
                        } else {
                            echo '<option value="" disabled>No classes assigned</option>';
                        }
                        ?>
                    </select>
                </div>
                
                <!-- Section Filter -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Select Section</label>
                    <select name="section_id" id="section_filter" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" <?php echo ($class_id == 0) ? 'disabled' : ''; ?>>
                        <option value="">All Sections</option>
                        <?php foreach ($sections as $section): ?>
                            <option value="<?php echo $section['id']; ?>" <?php echo ($section_id == $section['id']) ? 'selected' : ''; ?>>
                                <?php echo $section['section_name']; ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                
                <!-- Subject Filter -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Select Subject</label>
                    <select name="subject_id" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <option value="">All Subjects</option>
                        <?php 
                        if (mysqli_num_rows($teacher_subjects_result) > 0) {
                            mysqli_data_seek($teacher_subjects_result, 0);
                            while ($subject = mysqli_fetch_assoc($teacher_subjects_result)): 
                        ?>
                            <option value="<?php echo $subject['id']; ?>" <?php echo ($subject_id == $subject['id']) ? 'selected' : ''; ?>>
                                <?php echo $subject['subject_name']; ?>
                            </option>
                        <?php 
                            endwhile;
                        } else {
                            echo '<option value="" disabled>No subjects assigned</option>';
                        }
                        ?>
                    </select>
                </div>
                
                <!-- Buttons -->
                <div class="flex items-end space-x-2">
                    <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg flex items-center h-10">
                        <i class="fas fa-filter mr-2"></i> Filter
                    </button>
                    <a href="teacher_lesson.php" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-lg flex items-center h-10">
                        <i class="fas fa-times mr-2"></i> Clear
                    </a>
                    <a href="teacher_lesson.php?action=create" class="bg-green-600 hover:bg-green-700 text-white px-4 py-2 rounded-lg flex items-center h-10">
                        <i class="fas fa-plus mr-2"></i> New Lesson
                    </a>
                </div>
            </form>
        </div>

        <!-- Lesson Notes List -->
        <div class="bg-white p-4 rounded-lg border">
            <h3 class="text-lg font-semibold text-gray-800 mb-4">My Lesson Notes</h3>
            
            <?php if (!empty($lesson_notes)): ?>
                <div class="overflow-x-auto">
                    <table class="min-w-full bg-white">
                        <thead class="bg-gray-200 text-gray-700">
                            <tr>
                                <th class="py-3 px-4 text-left">Topic</th>
                                <th class="py-3 px-4 text-left">Subject</th>
                                <th class="py-3 px-4 text-left">Class</th>
                                <th class="py-3 px-4 text-left">Section</th>
                                <th class="py-3 px-4 text-left">Date</th>
                                <th class="py-3 px-4 text-left">Duration</th>
                                <th class="py-3 px-4 text-left">Status</th>
                                <th class="py-3 px-4 text-left">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="text-gray-600">
                            <?php foreach ($lesson_notes as $lesson): ?>
                                <tr class="border-b border-gray-200 hover:bg-gray-50">
                                    <td class="py-3 px-4"><?php echo $lesson['topic']; ?></td>
                                    <td class="py-3 px-4"><?php echo $lesson['subject_name']; ?></td>
                                    <td class="py-3 px-4"><?php echo $lesson['class_name']; ?></td>
                                    <td class="py-3 px-4"><?php echo $lesson['section_name'] ?: 'All'; ?></td>
                                    <td class="py-3 px-4"><?php echo date('M j, Y', strtotime($lesson['date_taught'])); ?></td>
                                    <td class="py-3 px-4"><?php echo $lesson['duration']; ?> mins</td>
                                    <td class="py-3 px-4">
                                        <span class="px-2 py-1 text-xs font-medium rounded-full 
                                            <?php echo $lesson['status'] === 'completed' ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800'; ?>">
                                            <?php echo ucfirst($lesson['status']); ?>
                                        </span>
                                    </td>
                                    <td class="py-3 px-4">
                                        <div class="flex space-x-2">
                                            <a href="teacher_lesson.php?action=view&lesson_id=<?php echo $lesson['id']; ?>" 
                                               class="text-blue-600 hover:text-blue-800" title="View">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="teacher_lesson.php?action=edit&lesson_id=<?php echo $lesson['id']; ?>" 
                                               class="text-yellow-600 hover:text-yellow-800" title="Edit">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <a href="teacher_lesson.php?delete_lesson=<?php echo $lesson['id']; ?>" 
                                               class="text-red-600 hover:text-red-800" title="Delete" 
                                               onclick="return confirm('Are you sure you want to delete this lesson note? This action cannot be undone.');">
                                                <i class="fas fa-trash"></i>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <p class="text-center py-4 text-gray-500">
                    No lesson notes found. <a href="teacher_lesson.php?action=create" class="text-blue-600 hover:underline">Create your first lesson note</a>.
                </p>
            <?php endif; ?>
        </div>
    <?php endif; ?>
</div>

<script>
// JavaScript to handle dynamic section loading based on class selection
document.getElementById('class_filter').addEventListener('change', function() {
    const classId = this.value;
    const sectionSelect = document.getElementById('section_filter');
    
    if (classId) {
        // Enable section dropdown
        sectionSelect.disabled = false;
        
        // Fetch sections for the selected class via AJAX
        fetch('get_teacher_section.php?class_id=' + classId + '&teacher_id=<?php echo $teacher_id; ?>')
            .then(response => response.json())
            .then(sections => {
                // Clear existing options except the first one
                while (sectionSelect.options.length > 1) {
                    sectionSelect.remove(1);
                }
                
                // Add new options
                sections.forEach(section => {
                    const option = document.createElement('option');
                    option.value = section.id;
                    option.textContent = section.section_name;
                    sectionSelect.appendChild(option);
                });
            })
            .catch(error => console.error('Error fetching sections:', error));
    } else {
        // Disable and clear section dropdown if no class is selected
        sectionSelect.disabled = true;
        while (sectionSelect.options.length > 1) {
            sectionSelect.remove(1);
        }
    }
});

// Enable section dropdown if class is already selected on page load
document.addEventListener('DOMContentLoaded', function() {
    const classId = document.getElementById('class_filter').value;
    const sectionSelect = document.getElementById('section_filter');
    
    if (classId) {
        sectionSelect.disabled = false;
    }
});
</script>

<?php
include 'include/footer.php';
ob_end_flush();
?>