<?php
include 'include/header.php';
include '../config/conn.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

// Check if student ID is provided
if (!isset($_GET['id']) || empty($_GET['id'])) {
    header('Location: students.php');
    exit();
}

$student_id = mysqli_real_escape_string($conn, $_GET['id']);

// Fetch student data with class and section names
$sql = "SELECT s.*, c.class_name, sec.section_name 
        FROM students s 
        LEFT JOIN classes c ON s.class = c.id 
        LEFT JOIN sections sec ON s.section = sec.id 
        WHERE s.id = '$student_id'";
$result = mysqli_query($conn, $sql);

if (mysqli_num_rows($result) == 0) {
    echo "<div class='bg-white p-6 '><div class='bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4'>Student not found.</div></div>";
    include 'include/footer.php';
    exit();
}

$student = mysqli_fetch_assoc($result);

// Fetch parent information if parent_id exists
$parent_info = null;
if (!empty($student['parent_id'])) {
    $parent_id = mysqli_real_escape_string($conn, $student['parent_id']);
    $parent_sql = "SELECT * FROM parents WHERE id = '$parent_id'";
    $parent_result = mysqli_query($conn, $parent_sql);
    
    if (mysqli_num_rows($parent_result) > 0) {
        $parent_info = mysqli_fetch_assoc($parent_result);
    }
}

// Fetch admin name who created this record
$created_by = $student['created_by'];
$admin_sql = "SELECT name FROM users WHERE id = '$created_by'";
$admin_result = mysqli_query($conn, $admin_sql);
$admin_name = "Unknown";
if (mysqli_num_rows($admin_result) > 0) {
    $admin_data = mysqli_fetch_assoc($admin_result);
    $admin_name = $admin_data['name'];
}
?>

<div class="bg-white p-6 ">
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-2xl font-bold text-gray-800">Student Profile</h2>
        <div class="flex space-x-2">
            <a href="edit_student.php?id=<?php echo $student_id; ?>" class="bg-yellow-500 hover:bg-yellow-600 text-white px-4 py-2  flex items-center">
                <i class="fas fa-edit mr-2"></i> Edit
            </a>
            <a href="students.php" class="bg-gray-500 hover:bg-gray-600 text-white px-4 py-2  flex items-center">
                <i class="fas fa-arrow-left mr-2"></i> Back to List
            </a>
        </div>
    </div>

    <!-- Student Header -->
    <div class="bg-blue-50 p-6  mb-6 flex items-center">
        <div class="mr-4">
            <?php if (!empty($student['photo'])): ?>
                <img src="<?php echo $student['photo']; ?>" alt="<?php echo $student['full_name']; ?>" class="w-24 h-24 rounded-full object-cover border-4 border-white shadow">
            <?php else: ?>
                <div class="w-24 h-24 rounded-full bg-blue-100 flex items-center justify-center border-4 border-white shadow">
                    <i class="fas fa-user-graduate text-blue-400 text-3xl"></i>
                </div>
            <?php endif; ?>
        </div>
        <div>
            <h1 class="text-2xl font-bold text-gray-800"><?php echo htmlspecialchars($student['full_name']); ?></h1>
            <p class="text-gray-600">ID: <?php echo htmlspecialchars($student['student_id']); ?></p>
            <div class="flex items-center mt-2">
                <?php if ($student['status'] == 'active'): ?>
                    <span class="bg-green-100 text-green-800 text-xs font-medium px-2.5 py-0.5 rounded-full">Active</span>
                <?php elseif ($student['status'] == 'inactive'): ?>
                    <span class="bg-red-100 text-red-800 text-xs font-medium px-2.5 py-0.5 rounded-full">Inactive</span>
                <?php elseif ($student['status'] == 'graduated'): ?>
                    <span class="bg-yellow-100 text-yellow-800 text-xs font-medium px-2.5 py-0.5 rounded-full">Graduated</span>
                <?php elseif ($student['status'] == 'transferred'): ?>
                    <span class="bg-indigo-100 text-indigo-800 text-xs font-medium px-2.5 py-0.5 rounded-full">Transferred</span>
                <?php endif; ?>
                <span class="mx-2 text-gray-400">•</span>
                <span class="text-gray-600"><i class="fas fa-graduation-cap mr-1"></i> <?php echo htmlspecialchars($student['class_name']); ?> - <?php echo htmlspecialchars($student['section_name']); ?></span>
                <span class="mx-2 text-gray-400">•</span>
                <span class="text-gray-600"><i class="fas fa-hashtag mr-1"></i> Roll: <?php echo htmlspecialchars($student['roll_number']); ?></span>
            </div>
        </div>
    </div>

    <!-- Student Information in Table Format -->
    <div class="overflow-x-auto mb-6">
        <table class="min-w-full bg-white border border-gray-200">
            <thead class="bg-gray-100">
                <tr>
                    <th colspan="2" class="py-3 px-4 text-left text-gray-700 font-semibold">Personal Information</th>
                </tr>
            </thead>
            <tbody class="text-gray-600">
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium w-1/4">Date of Birth</td>
                    <td class="py-3 px-4"><?php echo !empty($student['dob']) ? date('F j, Y', strtotime($student['dob'])) : 'Not provided'; ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Gender</td>
                    <td class="py-3 px-4"><?php echo !empty($student['gender']) ? ucfirst($student['gender']) : 'Not provided'; ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Nationality</td>
                    <td class="py-3 px-4"><?php echo !empty($student['nationality']) ? htmlspecialchars($student['nationality']) : 'Not provided'; ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">ID Number</td>
                    <td class="py-3 px-4"><?php echo !empty($student['id_number']) ? htmlspecialchars($student['id_number']) : 'Not provided'; ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Blood Group</td>
                    <td class="py-3 px-4"><?php echo !empty($student['blood_group']) ? htmlspecialchars($student['blood_group']) : 'Not provided'; ?></td>
                </tr>
            </tbody>
        </table>
    </div>

    <div class="overflow-x-auto mb-6">
        <table class="min-w-full bg-white border border-gray-200">
            <thead class="bg-gray-100">
                <tr>
                    <th colspan="2" class="py-3 px-4 text-left text-gray-700 font-semibold">Contact Information</th>
                </tr>
            </thead>
            <tbody class="text-gray-600">
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium w-1/4">Address</td>
                    <td class="py-3 px-4"><?php echo !empty($student['address']) ? htmlspecialchars($student['address']) : 'Not provided'; ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Phone</td>
                    <td class="py-3 px-4"><?php echo !empty($student['phone']) ? htmlspecialchars($student['phone']) : 'Not provided'; ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Email</td>
                    <td class="py-3 px-4"><?php echo !empty($student['email']) ? htmlspecialchars($student['email']) : 'Not provided'; ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Emergency Contact</td>
                    <td class="py-3 px-4">
                        <?php if (!empty($student['emergency_contact'])): ?>
                            <?php echo htmlspecialchars($student['emergency_contact']); ?>
                            <?php if (!empty($student['emergency_phone'])): ?>
                                (<?php echo htmlspecialchars($student['emergency_phone']); ?>)
                            <?php endif; ?>
                        <?php else: ?>
                            Not provided
                        <?php endif; ?>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>

    <div class="overflow-x-auto mb-6">
        <table class="min-w-full bg-white border border-gray-200">
            <thead class="bg-gray-100">
                <tr>
                    <th colspan="2" class="py-3 px-4 text-left text-gray-700 font-semibold">Academic Information</th>
                </tr>
            </thead>
            <tbody class="text-gray-600">
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium w-1/4">Admission Date</td>
                    <td class="py-3 px-4"><?php echo !empty($student['admission_date']) ? date('F j, Y', strtotime($student['admission_date'])) : 'Not provided'; ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Class</td>
                    <td class="py-3 px-4"><?php echo htmlspecialchars($student['class_name']); ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Section</td>
                    <td class="py-3 px-4"><?php echo htmlspecialchars($student['section_name']); ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Roll Number</td>
                    <td class="py-3 px-4"><?php echo htmlspecialchars($student['roll_number']); ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Previous School</td>
                    <td class="py-3 px-4"><?php echo !empty($student['previous_school']) ? htmlspecialchars($student['previous_school']) : 'Not provided'; ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Previous Grades</td>
                    <td class="py-3 px-4"><?php echo !empty($student['previous_grades']) ? htmlspecialchars($student['previous_grades']) : 'Not provided'; ?></td>
                </tr>
            </tbody>
        </table>
    </div>

    <div class="overflow-x-auto mb-6">
        <table class="min-w-full bg-white border border-gray-200">
            <thead class="bg-gray-100">
                <tr>
                    <th colspan="2" class="py-3 px-4 text-left text-gray-700 font-semibold">Medical Information</th>
                </tr>
            </thead>
            <tbody class="text-gray-600">
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium w-1/4">Medical Conditions</td>
                    <td class="py-3 px-4"><?php echo !empty($student['medical_conditions']) ? htmlspecialchars($student['medical_conditions']) : 'None'; ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Allergies</td>
                    <td class="py-3 px-4"><?php echo !empty($student['allergies']) ? htmlspecialchars($student['allergies']) : 'None'; ?></td>
                </tr>
            </tbody>
        </table>
    </div>

    <div class="overflow-x-auto mb-6">
        <table class="min-w-full bg-white border border-gray-200">
            <thead class="bg-gray-100">
                <tr>
                    <th colspan="2" class="py-3 px-4 text-left text-gray-700 font-semibold">Parent/Guardian Information</th>
                </tr>
            </thead>
            <tbody class="text-gray-600">
                <?php if ($parent_info): ?>
                    <!-- Display parent information from parents table -->
                    <tr class="border-b border-gray-200 hover:bg-gray-50">
                        <td class="py-3 px-4 font-medium w-1/4">Parent Name</td>
                        <td class="py-3 px-4"><?php echo htmlspecialchars($parent_info['fullname']); ?></td>
                    </tr>
                    <tr class="border-b border-gray-200 hover:bg-gray-50">
                        <td class="py-3 px-4 font-medium">Username</td>
                        <td class="py-3 px-4"><?php echo htmlspecialchars($parent_info['username']); ?></td>
                    </tr>
                    <tr class="border-b border-gray-200 hover:bg-gray-50">
                        <td class="py-3 px-4 font-medium">Email</td>
                        <td class="py-3 px-4"><?php echo htmlspecialchars($parent_info['email']); ?></td>
                    </tr>
                    <tr class="border-b border-gray-200 hover:bg-gray-50">
                        <td class="py-3 px-4 font-medium">Gender</td>
                        <td class="py-3 px-4"><?php echo !empty($parent_info['gender']) ? ucfirst($parent_info['gender']) : 'Not provided'; ?></td>
                    </tr>
                    <tr class="border-b border-gray-200 hover:bg-gray-50">
                        <td class="py-3 px-4 font-medium">Date of Birth</td>
                        <td class="py-3 px-4"><?php echo !empty($parent_info['birth']) ? date('F j, Y', strtotime($parent_info['birth'])) : 'Not provided'; ?></td>
                    </tr>
                    <tr class="border-b border-gray-200 hover:bg-gray-50">
                        <td class="py-3 px-4 font-medium">Address</td>
                        <td class="py-3 px-4"><?php echo !empty($parent_info['address']) ? htmlspecialchars($parent_info['address']) : 'Not provided'; ?></td>
                    </tr>
                    <tr class="border-b border-gray-200 hover:bg-gray-50">
                        <td class="py-3 px-4 font-medium">Contact</td>
                        <td class="py-3 px-4"><?php echo !empty($parent_info['contact']) ? htmlspecialchars($parent_info['contact']) : 'Not provided'; ?></td>
                    </tr>
                <?php else: ?>
                    <!-- Fallback to student table parent fields if no parent_id exists -->
                    <tr class="border-b border-gray-200 hover:bg-gray-50">
                        <td class="py-3 px-4 font-medium w-1/4">Father's Name</td>
                        <td class="py-3 px-4"><?php echo !empty($student['father_name']) ? htmlspecialchars($student['father_name']) : 'Not provided'; ?></td>
                    </tr>
                    <tr class="border-b border-gray-200 hover:bg-gray-50">
                        <td class="py-3 px-4 font-medium">Father's Occupation</td>
                        <td class="py-3 px-4"><?php echo !empty($student['father_occupation']) ? htmlspecialchars($student['father_occupation']) : 'Not provided'; ?></td>
                    </tr>
                    <tr class="border-b border-gray-200 hover:bg-gray-50">
                        <td class="py-3 px-4 font-medium">Father's Phone</td>
                        <td class="py-3 px-4"><?php echo !empty($student['father_phone']) ? htmlspecialchars($student['father_phone']) : 'Not provided'; ?></td>
                    </tr>
                    <tr class="border-b border-gray-200 hover:bg-gray-50">
                        <td class="py-3 px-4 font-medium">Father's Email</td>
                        <td class="py-3 px-4"><?php echo !empty($student['father_email']) ? htmlspecialchars($student['father_email']) : 'Not provided'; ?></td>
                    </tr>
                    <tr class="border-b border-gray-200 hover:bg-gray-50">
                        <td class="py-3 px-4 font-medium">Mother's Name</td>
                        <td class="py-3 px-4"><?php echo !empty($student['mother_name']) ? htmlspecialchars($student['mother_name']) : 'Not provided'; ?></td>
                    </tr>
                    <tr class="border-b border-gray-200 hover:bg-gray-50">
                        <td class="py-3 px-4 font-medium">Mother's Occupation</td>
                        <td class="py-3 px-4"><?php echo !empty($student['mother_occupation']) ? htmlspecialchars($student['mother_occupation']) : 'Not provided'; ?></td>
                    </tr>
                    <tr class="border-b border-gray-200 hover:bg-gray-50">
                        <td class="py-3 px-4 font-medium">Mother's Phone</td>
                        <td class="py-3 px-4"><?php echo !empty($student['mother_phone']) ? htmlspecialchars($student['mother_phone']) : 'Not provided'; ?></td>
                    </tr>
                    <tr class="border-b border-gray-200 hover:bg-gray-50">
                        <td class="py-3 px-4 font-medium">Mother's Email</td>
                        <td class="py-3 px-4"><?php echo !empty($student['mother_email']) ? htmlspecialchars($student['mother_email']) : 'Not provided'; ?></td>
                    </tr>
                    <?php if (!empty($student['guardian_name'])): ?>
                    <tr class="border-b border-gray-200 hover:bg-gray-50">
                        <td class="py-3 px-4 font-medium">Guardian's Name</td>
                        <td class="py-3 px-4"><?php echo htmlspecialchars($student['guardian_name']); ?></td>
                    </tr>
                    <tr class="border-b border-gray-200 hover:bg-gray-50">
                        <td class="py-3 px-4 font-medium">Relationship</td>
                        <td class="py-3 px-4"><?php echo !empty($student['guardian_relation']) ? htmlspecialchars($student['guardian_relation']) : 'Not provided'; ?></td>
                    </tr>
                    <tr class="border-b border-gray-200 hover:bg-gray-50">
                        <td class="py-3 px-4 font-medium">Guardian's Phone</td>
                        <td class="py-3 px-4"><?php echo !empty($student['guardian_phone']) ? htmlspecialchars($student['guardian_phone']) : 'Not provided'; ?></td>
                    </tr>
                    <tr class="border-b border-gray-200 hover:bg-gray-50">
                        <td class="py-3 px-4 font-medium">Guardian's Email</td>
                        <td class="py-3 px-4"><?php echo !empty($student['guardian_email']) ? htmlspecialchars($student['guardian_email']) : 'Not provided'; ?></td>
                    </tr>
                    <tr class="border-b border-gray-200 hover:bg-gray-50">
                        <td class="py-3 px-4 font-medium">Guardian's Address</td>
                        <td class="py-3 px-4"><?php echo !empty($student['guardian_address']) ? htmlspecialchars($student['guardian_address']) : 'Not provided'; ?></td>
                    </tr>
                    <?php endif; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <div class="overflow-x-auto mb-6">
        <table class="min-w-full bg-white border border-gray-200">
            <thead class="bg-gray-100">
                <tr>
                    <th colspan="2" class="py-3 px-4 text-left text-gray-700 font-semibold">System Information</th>
                </tr>
            </thead>
            <tbody class="text-gray-600">
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium w-1/4">Registered On</td>
                    <td class="py-3 px-4"><?php echo date('F j, Y', strtotime($student['created_at'])); ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Registered By</td>
                    <td class="py-3 px-4"><?php echo htmlspecialchars($admin_name); ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Last Updated</td>
                    <td class="py-3 px-4"><?php echo date('F j, Y', strtotime($student['updated_at'])); ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Status</td>
                    <td class="py-3 px-4">
                        <?php if ($student['status'] == 'active'): ?>
                            <span class="bg-green-100 text-green-800 text-xs font-medium px-2.5 py-0.5 rounded-full">Active</span>
                        <?php elseif ($student['status'] == 'inactive'): ?>
                            <span class="bg-red-100 text-red-800 text-xs font-medium px-2.5 py-0.5 rounded-full">Inactive</span>
                        <?php elseif ($student['status'] == 'graduated'): ?>
                            <span class="bg-yellow-100 text-yellow-800 text-xs font-medium px-2.5 py-0.5 rounded-full">Graduated</span>
                        <?php elseif ($student['status'] == 'transferred'): ?>
                            <span class="bg-indigo-100 text-indigo-800 text-xs font-medium px-2.5 py-0.5 rounded-full">Transferred</span>
                        <?php endif; ?>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
</div>

<?php include 'include/footer.php'; ?>